/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.group.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:12
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)group.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	group.cxx
*
* PURPOSE
*	The OTSO class group is the base class for several
*	different types of container classes.  The container
*	classes contain collections of objects, ordered in
*	different ways (fifo, lifo, dyndir, ring, heap, etc).
*
*	The base class "Group" defines certain shared properties
*	of a generic container class, (e.g. the ability to put,
*	or get a list of objects to/from the container, the ability
*	to find the first object, the ability to iterate through
*	the list, etc.)
*
* BUGS
* MODIFICATIONS
**********************************************************************/

#define CHANNEL_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1	/* *MJS* changes - statistics gathering */

#if (SIMULATING || STATISTICS)
				// *MJS* changes - statistics gathering
#define STATOBJ_HXX	1
#define SAMPLDIS_HXX	1
#define SAMPLCON_HXX	1
#endif

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


//----------------------------------------------------------------

GP Group::dummyGP;

Group::Group()
  : size_(0)
{}

Group::~Group() {
  //printf("@@@ ~Group \"%s\", %d elements\n", (char*)className(), size());
}

sint32 Group::size() const {return size_;}

sint32 Group::dynamicSize() const {return size_;}


// *MJS* changes: reimplemented put() and get().

Group& Group::put(const GE r) {
#if SIMULATING
  // In order to calculate, how long a time the Runner has spent in this,
  // we stamp the Runner before putting it into this. In the simulation
  // environment, we have to do this even if we are not gathering statistics
  // for a simulation experiment, because when the gathering starts, all
  // the queue elements have to be stamped!
  r->toQueue = time();
#endif

  myPut(r);		// call the (possibly derived Class's) put function

#if SIMULATING
  if (simExpActive) {
    qLen += size();     // update integral for queue length
    putCount++;
  }
#endif

  return *this;
}

Group& Group::get(GE& r) {
  myGet(r);	// call the (possibly derived Class's) get function.

#if SIMULATING
  if (simExpActive) {
    qLen += size();
    getCount++;
    waited = time() - r->toQueue;
    if (waited == Time((uint32) 0))
      zeroWaitCount++;
    waitTimes += (double) waited;
  }
#endif

  return *this;
}


Group& Group::put(const GE o1, const GE o2,
		  const GE o3, const GE o4,
		  const GE o5, const GE o6) {
  put(o1);
  if (o2) put(o2);
  if (o3) put(o3);
  if (o4) put(o4);
  if (o5) put(o5);
  if (o6) put(o6);
  return *this;
}

Group& Group::putAnyway(const GE e) {
  return put(e);
}

Group& Group::getAnyway(GE& e) {
  return get(e);
}

boolean Group::over(const GP l) {
  return (l == &dummyRunner || l == NULL);
}

GE Group::head() {
  return first(dummyGP);
}

boolean	Group::isEmpty() {
  return (size() == 0);
}

void Group::ask(Istream&) {
  dout << "***** Group::ask() does nothing!\n";
} 

void Group::print(Ostream& os) {
  // there should be a separate tool for output beautifying
  const int elementsPerLine = 9999; 
  int i = 0;
  os << "(";
  if (isEmpty()) os << "empty";
  else {
    FOR_EACH_runner_IN(*this) {
      os << runner->name();         // *runner is too verbose
      if (++i < elementsPerLine)
	os << " ";
      else {
	os << "\n";
	i = 0;
      }
    }
  }
  os << ") ";
  if (size() > 1) os << size() << " elements ";
}

void Group::printMsgs(Ostream* os, boolean help) {
  sint32 i = 0;
  Runner* last = 0;
  const sint16 N = 4;
  FOR_EACH_runner_IN(*this) {
    if (i < N) {
      *os << i << " " << runner->name();
      if (help) 	*os << "\n";
      else	*os << "  ";
    }
    i++;
    last = runner;
  }
  if (i > N)  *os << " ... ";
  if (i >= N && last) {
    *os << i << " " << last->name();
    if (help) 	*os << "\n";
    else	*os << "  ";
  }

  Object::printMsgs(os, help);
}

void Group::reset() {
  Runner* rp = 0;
  get(rp);
  while (rp && rp != &dummyRunner) {
    rp->reset();
    get(rp);
  }
  if (size_ != 0)
    OTSO_WARNING("OTSO internal error: size() == " << size() << " after " << className() << "::reset");
}

#if SIMULATING
// *MJS* changes: Group methods need in SIMULATION:

void Group::startSimExp()
{
  StatObj::startSimExp();

  initCount = size();
  putCount  = 0;
  getCount  = 0;
  zeroWaitCount = 0;

  waitTimes.reset();
  qLen.reset();
  qLen.start();
}

void Group::finishSimExp()
{
  StatObj::finishSimExp();
  qLen.stop();
}

SimObs* Group::createSimObs()
{
  return new SOGroup(this);
}

SOGroup::SOGroup(Group* g)
{
  if (!g) return;

  gClassName    = g->className();
  initCount     = g->initCount;
  putCount      = g->putCount;
  getCount      = g->getCount;
  zeroWaitCount = g->zeroWaitCount;
  waitTimes     = g->waitTimes;
  qLen          = g->qLen;
}

SOGroup::~SOGroup() {}

void SOGroup::print(Ostream& os)
{
  os << INDENT << "- " << gClassName << ";\n";
  os.addIndent(2);

  os << INDENT << "messages: " 
     << initCount << " initially, " 
     << putCount << " received\n"
     ;

  if (!initCount && !putCount) {
    os.addIndent(-2);
    return;
  }

  os << INDENT << "          " << getCount << " run";

  if (getCount)
    os << form(" (%d [%.2f %%] without waiting)\n", (int)zeroWaitCount, 
	       100 * (float) zeroWaitCount / (float) getCount);
  else
    os << "\n";

  os << INDENT << "queueing time (sec) : ";
  waitTimes.print(os);

  os << INDENT << "queue length        : ";
  qLen.print(os);

  os.addIndent(-2);
}
#endif
