/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.timerSP.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:46
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


#ifndef TIMERSP_HXX
#define TIMERSP_HXX

/**********************************************************************
 FILE timerSP.hx
**********************************************************************/

typedef sint32 TimerId;
//in object.hxx: typedef sint32 Time;
//in object.hxx: typedef Time Delay;

/**********************************************************************
This interface defines timer services for OTSO Runners.
The single timers are all handled by a timer service provider
such as TimerMan. Only the TimerMan has access to the timers.
Runners using timers can access their timers through the 
services specified in this class. 

A TimerId (sint32) identifies a single timer unit.
create() returns a TimerId, which should be given for the other functions.

.SH BUGS

The time unit is currently a second.  The running time of a timer 
cannot be shorter than a second.

The owner of a timer, to whom the timeout is sent, must be an OTSO Runner.

.SH EXAMPLE
.nf

Runner aRunner;
TimerMan rolex;
TimerSPPtr myTimerSP = rolex;
TimerId id = myTimerSP->create(5, RunnerPtr(&aRunner, &aRunner));
myTimerSP->start(id, 10);

.fi
**********************************************************************/

interface class TimerSP {
public:
  virtual TimerId create (Time waitFor, RunnerPtr owner) = 0;
                             //Creates a timer and returns its identifier.
                             //When started and not stopped, 
                             //the timer sends a timeout(identifier) to its
                             //owner after a delay.
                             //The initial delay is specified by 'waitFor'.
                             //The value of delay can be changed
                             //by start().

  virtual async	restart (TimerId id) = 0;
                             //Restart a timer (id) with its current delay.
/**********
  virtual async	start (
    TimerId id, uint32 waitForSec=0, uint32 waitForMicrosec=0
  ) = 0;
**********/ /* */
  virtual async start(TimerId id, double waitFor=0.0) = 0;
                             //Start a Timer (id).  'waitFor...' specifies
                             // the running time (i.e. delay) of the Timer.
                             // This delay is used until modified by another
                             // start() call.

                             //BUG: waitFor should be of type Time instead
                             // of double or uint32's, but default initializing
                             // of C++ object args not possible in Cfront 2.1. 

  virtual async	stop (TimerId id) = 0;
                             //Stops a timer.
  virtual async	kill (TimerId id) = 0;
                             //Deletes a timer unit.
  virtual Time	timeLeft (TimerId id) = 0;
                             //Returns the number of time units remaining
                             //before a timer expires and sends a timeout().
};

#endif
