/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.timerSP.cx
 * Vers: 5.2    Time: 92/08/04, 12:39:39
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)timerSP.cx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/******************************************************************
* NAME timerSP.cx
*
* PURPOSE
*	OTSO Timer Service Provider Interface.
******************************************************************/

#include "OTSO.hxx"
#include "timerSP.hxx"



#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class TimerSP
**********************************************************************/

/********** TimerSP_agent *****************************/

String TimerSP_agent::className() const {return "TimerSP_agent";}

TimerSP_agent::TimerSP_agent(TimerSP* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

TimerSP_agent::~TimerSP_agent() {}

TimerSP* TimerSP_agent::sPInterface() {return sPInterface_;}

void TimerSP_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (TimerSP*)p : this );
}

/********** TimerSPPtr *****************************/

String TimerSPPtr::className() const {return "TimerSPPtr";}

TimerSPPtr::TimerSPPtr(const TimerSPPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

TimerSPPtr::TimerSPPtr()
  : dap(new TimerSP_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

TimerSPPtr::TimerSPPtr(TimerSP* i, Object* o)
  : dap(new TimerSP_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

TimerSPPtr::TimerSPPtr(sint8) : dap(0) {}

TimerSPPtr::TimerSPPtr(const Agent& staticAgent) 
  : dap(new TimerSP_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'TimerSP'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

TimerSPPtr::~TimerSPPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* TimerSPPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void TimerSPPtr::setAgent(TimerSP_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

TimerSPPtr::operator TimerSP* () {return operator->();}

TimerSP* TimerSPPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    TimerSP_agent* ret = new TimerSP_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("TimerSPPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void TimerSPPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    TimerSP_agent* a = new TimerSP_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void TimerSPPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void TimerSPPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

TimerSPPtr& TimerSPPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

TimerSPPtr& TimerSPPtr::operator=(const TimerSPPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    TimerSP_agent* r = rhs.dap;
    TimerSP_agent* newDap = new TimerSP_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((TimerSP*)dap);
      dap->Agent::setName(r->Agent::name());
    }
    dap->Agent::connect();
  }
  return *this;
}


/************** code for TimerSP_create ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_create, 
 ( OTSO_DATA_MEMBER(Time,waitFor,"")
  ,OTSO_DATA_MEMBER(RunnerPtr,owner,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_create::className() const {return "create";}

ReturnValue TimerSP_create::returnValue() {return &returnValue_;}

Message* TimerSP_create::send() {
  return (TimerSP_create*)sendAndReturnAValue();
}

Agent* TimerSP_create::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_create::multiPtr() {return &otsoPtr;}

TimerId TimerSP_agent::create_in {
  TimerSP_create* otsoTmpMsg = new create_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return otsoDummyOf((TimerId*)0);
  }
  if (isOtsoPromiseType(&otsoTmpMsg->returnValue_)) {
    otsoTmpMsg->send();
    return otsoTmpMsg->returnValue_;
  }
  TimerId otsoRet = ((TimerSP_create*)otsoTmpMsg->sendAndReturnAValue())->returnValue_;
  delete otsoTmpMsg;
  return otsoRet;
}

NewMsg* new_TimerSP_create() {
  return new TimerSP_create;
}

void TimerSP_create::run() {
  dest()->setSender(otsoPtr.agent());
  returnValue_ =  otsoPtr.dap->sPInterface()->create_out;
  if (!isOtsoPromiseType(&returnValue_)) sendReturnValue(this);
  return;
}

TimerSP_create::TimerSP_create() {
  returnValueType_ = *otsoTypeOf((TimerId*)0);
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_create*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_create::~TimerSP_create() {}

TimerSP_create::TimerSP_create(Time ddOTSOp0, RunnerPtr ddOTSOp1)
		: otsoPtr(0 /*no new agent*/)
		, waitFor(ddOTSOp0)
		, owner(ddOTSOp1)
{
  returnValueType_ = *otsoTypeOf((TimerId*)0);
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_create*) defined
  setPriority(otsoRunnerPriority(this));
}

void TimerSP_create::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &waitFor);
  otsoOutEncode(od, &owner);
}

void TimerSP_create::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &waitFor);
  otsoOutDecode(id, &owner);
}


/************** code for TimerSP_restart ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_restart, 
 ( OTSO_DATA_MEMBER(TimerId,id,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_restart::className() const {return "restart";}

Agent* TimerSP_restart::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_restart::multiPtr() {return &otsoPtr;}

async TimerSP_agent::restart_in {
  TimerSP_restart* otsoTmpMsg = new restart_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
}

NewMsg* new_TimerSP_restart() {
  return new TimerSP_restart;
}

void TimerSP_restart::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->restart_out;
  delete this;
  return;
}

TimerSP_restart::TimerSP_restart() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_restart*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_restart::~TimerSP_restart() {}

TimerSP_restart::TimerSP_restart(TimerId ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
{
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_restart*) defined
  setPriority(otsoRunnerPriority(this));
}


/************** code for TimerSP_start ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_start, 
 ( OTSO_DATA_MEMBER(TimerId,id,"")
  ,OTSO_DATA_MEMBER(double,waitFor,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_start::className() const {return "start";}

Agent* TimerSP_start::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_start::multiPtr() {return &otsoPtr;}

async TimerSP_agent::start_in {
  TimerSP_start* otsoTmpMsg = new start_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
}

NewMsg* new_TimerSP_start() {
  return new TimerSP_start;
}

void TimerSP_start::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->start_out;
  delete this;
  return;
}

TimerSP_start::TimerSP_start() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_start*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_start::~TimerSP_start() {}

TimerSP_start::TimerSP_start(TimerId ddOTSOp0, double ddOTSOp1)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
		, waitFor(ddOTSOp1)
{
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_start*) defined
  setPriority(otsoRunnerPriority(this));
}


/************** code for TimerSP_stop ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_stop, 
 ( OTSO_DATA_MEMBER(TimerId,id,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_stop::className() const {return "stop";}

Agent* TimerSP_stop::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_stop::multiPtr() {return &otsoPtr;}

async TimerSP_agent::stop_in {
  TimerSP_stop* otsoTmpMsg = new stop_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
}

NewMsg* new_TimerSP_stop() {
  return new TimerSP_stop;
}

void TimerSP_stop::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->stop_out;
  delete this;
  return;
}

TimerSP_stop::TimerSP_stop() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_stop*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_stop::~TimerSP_stop() {}

TimerSP_stop::TimerSP_stop(TimerId ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
{
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_stop*) defined
  setPriority(otsoRunnerPriority(this));
}


/************** code for TimerSP_kill ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_kill, 
 ( OTSO_DATA_MEMBER(TimerId,id,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_kill::className() const {return "kill";}

Agent* TimerSP_kill::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_kill::multiPtr() {return &otsoPtr;}

async TimerSP_agent::kill_in {
  TimerSP_kill* otsoTmpMsg = new kill_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  source()->sendOrQueue(*otsoTmpMsg);
}

NewMsg* new_TimerSP_kill() {
  return new TimerSP_kill;
}

void TimerSP_kill::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->kill_out;
  delete this;
  return;
}

TimerSP_kill::TimerSP_kill() {
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_kill*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_kill::~TimerSP_kill() {}

TimerSP_kill::TimerSP_kill(TimerId ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
{
  returnValueType_ = otsoType_async;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_kill*) defined
  setPriority(otsoRunnerPriority(this));
}


/************** code for TimerSP_timeLeft ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(TimerSP_timeLeft, 
 ( OTSO_DATA_MEMBER(TimerId,id,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String TimerSP_timeLeft::className() const {return "timeLeft";}

ReturnValue TimerSP_timeLeft::returnValue() {return &returnValue_;}

Message* TimerSP_timeLeft::send() {
  return (TimerSP_timeLeft*)sendAndReturnAValue();
}

Agent* TimerSP_timeLeft::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* TimerSP_timeLeft::multiPtr() {return &otsoPtr;}

Time TimerSP_agent::timeLeft_in {
  TimerSP_timeLeft* otsoTmpMsg = new timeLeft_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return otsoDummyOf((Time*)0);
  }
  if (isOtsoPromiseType(&otsoTmpMsg->returnValue_)) {
    otsoTmpMsg->send();
    return otsoTmpMsg->returnValue_;
  }
  Time otsoRet = ((TimerSP_timeLeft*)otsoTmpMsg->sendAndReturnAValue())->returnValue_;
  delete otsoTmpMsg;
  return otsoRet;
}

NewMsg* new_TimerSP_timeLeft() {
  return new TimerSP_timeLeft;
}

void TimerSP_timeLeft::run() {
  dest()->setSender(otsoPtr.agent());
  returnValue_ =  otsoPtr.dap->sPInterface()->timeLeft_out;
  if (!isOtsoPromiseType(&returnValue_)) sendReturnValue(this);
  return;
}

TimerSP_timeLeft::TimerSP_timeLeft() {
  returnValueType_ = *otsoTypeOf((Time*)0);
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_timeLeft*) defined
  setPriority(otsoRunnerPriority(this));
}

TimerSP_timeLeft::~TimerSP_timeLeft() {}

TimerSP_timeLeft::TimerSP_timeLeft(TimerId ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, id(ddOTSOp0)
{
  returnValueType_ = *otsoTypeOf((Time*)0);
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(TimerSP_timeLeft*) defined
  setPriority(otsoRunnerPriority(this));
}

void TimerSP_timeLeft::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &id);
}

void TimerSP_timeLeft::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &id);
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(TimerSP,
  ( OTSO_METHOD_MEMBER(TimerSP,create,"Creates a timer and returns its identifier. When started and not stopped,  the timer sends a timeout(identifier) to its owner after a delay. The initial delay is specified by 'waitFor'. The value of delay can be changed by start(). ")
   ,OTSO_METHOD_MEMBER(TimerSP,restart,"Restart a timer (id) with its current delay. ")
   ,OTSO_METHOD_MEMBER(TimerSP,start,"  Start a Timer (id).  'waitFor...' specifies  the running time (i.e. delay) of the Timer.  This delay is used until modified by another  start() call. BUG: waitFor should be of type Time instead  of double or uint32's, but default initializing  of C++ object args not possible in Cfront 2.1.  ")
   ,OTSO_METHOD_MEMBER(TimerSP,stop,"Stops a timer. ")
   ,OTSO_METHOD_MEMBER(TimerSP,kill,"Deletes a timer unit. ")
   ,OTSO_METHOD_MEMBER(TimerSP,timeLeft,"Returns the number of time units remaining before a timer expires and sends a timeout(). ")
  ));

#if 0
XXX& operator||(XXX& l, TimerSP& r) {
  return l;
}
#endif

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/
