/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.timer.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:44
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME	timer.hx
*
* PURPOSE
*	Kirsi's TimerObj, TimerList, TimerMan classes for OTSO.
*	Used with TimerSP interface.
*	See individual comments below.
*
* MODIFICATIONS
*  - I took this from Kirsi's simpletimer.[ch]x files
*    This should replace the other OTSO timer files ???
**********************************************************************/

#ifndef TIMERSP_HXX
#include "timerSP.hxx"	/*thus application modules include only timer.hx*/
#endif

/**********************************************************************
TimerObj is meant to be used by the timer service provider classes.
The objects that use timer services should access services through the
TimerSP interface.

Timerobj is a data structure that represents a single timer. 
It has timer specific data elements: elapsing time, timer interval
and timer id. 

.SH MODIFICATION
No more derived from Object, no more className().
**********************************************************************/

class TimerObj {
  friend class TimerMan;
  friend class TimerList;
public:
  void		print(Ostream& os);
  TimerObj (RunnerPtr owner, Time interval/*=0*/, TimerId id=0);
                                //Initializes the interval and id.
private:
  Time 		elapsing;       //elapsing time
  Time		interval;       //timer interval before elapsing
  TimerId	id;             //timer id
  RunnerPtr	owner;		//The object whose timeout() this may call.
};


/**********************************************************************
TimerList is a list structure containing TimerObj items. TimerMan
timer service implementation uses this list to keep the TimerObjs
in order.

TimerList is a lifo with certain extra characteristics. In addition to
getting the last-in-item with get() there is a remove() function which
gets an item specified by id. Also in addition to putting items with
lifo's put() there is function insert() which inserts the item
in the correct place ordered by the elapsing value.
**********************************************************************/

class TimerList : public VoidLifo {
public:
  Time*	     readFirst ();	 //Returns the elapsing time of the
                                 //first timerobject.
  TimerList& remove (TimerObj*& o, TimerId id);
                                 //Removes object specified by id from
                                 //the timerlist.
  TimerList& insert (TimerObj *o); 	
                                 //Inserts in order by elapsing value
                                 //so that that first elapsing timer
                                 //is the first element in list.
  virtual String  className () const;
  virtual void 	  print (Ostream& os);
                            	 //Prints the timerlist structure.
};



/**********************************************************************
TimerMan implements a timer service for OTSO objects. The services
are available to OTSO objects through timerSP interface functions.
Only TimerMan can access the timer Objects in it's timerlists.

TimerMan is only one implementation of timerSP service. There could
be several implementations of timerSP offering real or virtual time
services. Several timer services can run in the same process,
or also a timer service located in an other process could be used.

TimerMan is the first version of timer service implementation.
It simply keeps up two lists.  One for stopped timers and one for
running timers. 
When a timer service user asks for creation of timer, a new 
instance of TimerObj class is made and put to the list of stopped
timers.
The run() function checks the current time and then
goes to see if any of the timer units in the list of running timers
has elapsed. If a timer has elapsed it is moved to the list of stopped
timers and timeout is sent to the object who owns that timerunit.

.SH IMPORTANT

Each TimerMan instance must be run every now and then to check for timeouts.
Therefore they must be inserted into the scheduler's inQ (in a static Ring).
The position of TimerMan in scheduler's inQ determines
how often the expiration of timers is checked.

**********************************************************************/

implementation class TimerMan : public TimerSP, public Runner {
public:
  redefined TimerSP_interface;
  virtual void 	run(); 		   //Checks the timerlist for elapsed timers.

  virtual String className() const;
  virtual void	print (Ostream& os);
  TimerMan (Group* q = 0);	

private:
  TimerList	runList;
  TimerList	stopList;
  sint32	timerObjCount;	//the number of TimerObjs in lists
  sint32	counter;	//Running counter used for generating
				//new TimerIds.

  boolean	restartingFrom0;
	 		        //False until counter has 'overflown'.
			        //Restarts counting from 0.

  async		privateStart (
  		  TimerId id, boolean setInitialDelay,
//		  uint32 waitForSec=0, uint32 waitForMicrosec=0
		  double waitFor
		);	
                                //common start function for start() 
                                //and restart().

  void          updMinTimerOfSch();
};

