/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.timer.cx
 * Vers: 5.2    Time: 92/08/04, 12:39:37
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)timer.cx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME	timer.cx
*
* PURPOSE
*	Implementation of OTSO TimerObj, TimerList, TimerMan classes
*	
* MODIFICATIONS
*      -I took this from Kirsi's simpletimer.cx.
*      -28.10.91 Juha added "break;" and changed ">" to ">=" 
*	   in TimerList::insert (infinite loop if 2 
*	   timers with the same interval were started one after the other).
*
* BUGS
**********************************************************************/


#include "OTSO.hxx"
#include "timerSP.hxx"	/*Timer User interface (Service Provider primitives)*/
#include "timer.hxx"	/*Timer objects*/


///////////// class TimerObj /////////////////

TimerObj::TimerObj (RunnerPtr o, Time n, TimerId i) // *MJS* changes - jfr!
  : owner(o), interval(n), id(i)
{}

void TimerObj::print(Ostream& os)
{
  os << INDENT << "(id " << id 
     << ", running for " << interval << " seconds"
     << ", timeout at " << elapsing 
   //<< " to " << owner -> name() 
     << ") ";
}
 
///////////// class TimerList /////////////////

String TimerList::className() const {return "TimerList";}

TimerList& TimerList::insert (TimerObj *o)
{  // add in order by value
  VoidLink	*l = new VoidLink (o, NULL);
  VoidLink	*prev = fst;
  VoidLink	*pt = fst;

  if (fst == NULL) 
    fst = l;
  else if (((TimerObj *) (fst -> element)) -> elapsing >= o -> elapsing) {
      l -> next = fst;
      fst = l;
  }
  else {
    while (pt) {
      if (((TimerObj *) (pt -> element)) -> elapsing < o -> elapsing) {
        prev = pt;
	pt = pt -> next;
      }
      else {
	prev -> next = l;
	l -> next = pt;
	break;
      }
    }
    if (!pt)
      prev -> next = l;
  }
  return *this;
}

// *MJS* changes - jfr! *E* use Time retval instead ?
Time* TimerList::readFirst ()
{ // return the elapsing time of first object
  if (fst)
    return &((TimerObj *)(fst -> element)) -> elapsing ;
  else 
    return NULL ;
}

TimerList& TimerList::remove (TimerObj*& o, TimerId id)
{
  VoidLink	*prv = NULL, *pt = fst;

  if (fst) { 
    if (((TimerObj *)(fst -> element)) -> id == id) { /* if the first item on list
						    == id  */
      fst = fst -> next;
      o = (TimerObj *)(pt -> element);
      delete pt;
      return *this;
    }

    prv = pt;
    pt = pt -> next;

    while (pt) {
      if (((TimerObj *)(pt -> element)) -> id == id ) {
	prv -> next = pt -> next;
	o = (TimerObj *)(pt -> element);
	delete pt;
	return *this;
      }
      else {
	prv = pt;
	pt = pt -> next;
      }
    }
    o = 0;
    return *this;
  }
  else {	// fst == NULL
    o = 0;
    return *this;
  }
}

const int lineLength = 1;

void TimerList::print(Ostream& os)
{
  VoidLink	*link = fst;

  if (fst == 0) {
    os << "(empty)";
  }
  else {
    os << "(";
    os.addIndent(+2);
    int cnt = 0;

    while (link) {
      if ( ++cnt % lineLength == 0 )
	os << "\n"; os << INDENT;
      if (link -> element) {
	((TimerObj*)link -> element) -> print(os);
      }
      link = link -> next;
    }
    os.addIndent(-2);
    os << ")";
  }
}


//////////// class TimerMan ///////////////

/********************************************************************
* TimerMan simply keeps up two lists.
* One for stopped timers and one for running timers. The run function 
* checks the current time and then goes to see if any of the timer
* units in the list of running timers has elapsed. If a timer has
* elapsed it is moved to the list of stopped timers and timeout is
* sent to the object who owns that timerunit. 
* When a timer service user asks for creation of timer, a new 
* instance of TimerObj class is made and put to the list of stopped
* timers.
**********************************************************************/

String TimerMan::className() const {return "TimerMan";}

TimerMan::TimerMan(Group* q)
  : Runner(q)
  , timerObjCount(0)
  , restartingFrom0(false)
  , counter(0)
{
  trace.running = false;
  runStatus = RunStatus::enabled;
  setPriority(RunnerSP::lowRunnerPriority);
#if SIMULATING
  useImplDelay = false;
#endif
}

static const TimerId maxTimerId = 0x0FFFFFFF;

// *MJS* changes - jfr!
TimerId TimerMan::create (Time interval, RunnerPtr owner)
{
  TimerObj*	item = NULL;
  TimerId 	newId = 0;

  do {
    newId = this -> counter++ % ::maxTimerId;
    if (newId == ::maxTimerId-1) { this -> restartingFrom0 = true; }
    if (this -> restartingFrom0) {
      if (this -> timerObjCount >= ::maxTimerId-1) {
	OTSO_ERROR( "Cannot create timer - too many timers" );
	return 0;
      }

      //check if newId is in use
      OTSO_WARNING( "TimerMan::create : Poor efficiency" );
      this -> stopList.remove(item, newId);
      if (item == NULL) { this -> runList.remove(item, newId); }
    }
  } while (item != NULL);

  if (trace.actions) {
    dout << INDENT<< "TimerMan " << this -> name()
         << " creating timer " << newId << "\n";
  }

  item = new TimerObj (owner, interval, newId);
  item -> owner.agent() -> setSourceName(name());		//?
  item -> owner.agent() -> setSource(this, ::thisProcess);	//?
  this -> timerObjCount++;
  this -> stopList.put (item);
  return newId;
}

#if 0
async TimerMan::start(TimerId id, uint32 waitForSec, uint32 waitForMicrosec){
  boolean setInitialDelay = true;	// start timer, give delay value
  this -> privateStart (id, setInitialDelay, waitForSec, waitForMicrosec);
}
#else
async TimerMan::start(TimerId id, double waitFor) {
  boolean setInitialDelay = true;	// start timer, give delay value
  this -> privateStart (id, setInitialDelay, waitFor);
}
#endif

async TimerMan::restart (TimerId id) {
  boolean setInitialDelay = false;	// restart Timer with old delay value
  //this -> privateStart (id, setInitialDelay, 0, 0);
  this -> privateStart (id, setInitialDelay, 0.0);
}

#if 1
async TimerMan::privateStart(TimerId id, 
                             boolean setInitialDelay, 
			     double waitFor) 
{
  TimerObj	*item = NULL;
  Time		delay (waitFor);

  this -> stopList.remove (item, id);
  if (item == NULL) {
    this -> runList.remove (item, id);
    OTSO_WARNING( "Cannot start. Timer " << id << " does not exist. " );
  } else {
    if (setInitialDelay == true) { item -> interval = delay; }
    item -> elapsing = time() + item -> interval;
    this -> runList.insert (item);
  }

  //myScheduler() -> setMinTimer (*runList.readFirst());
  updMinTimerOfSch();		// *MJSII*
}
#else

async TimerMan::privateStart(
 TimerId id, boolean setInitialDelay, uint32 waitForSec, uint32 waitForMicrosec
) {
  TimerObj	*item = NULL;
  Time		delay (waitForSec, waitForMicrosec);

  this -> stopList.remove (item, id);
  if (item == NULL) {
    this -> runList.remove (item, id);
    OTSO_WARNING( "Cannot start. Timer " << id << " does not exist. " );
  } else {
    if (setInitialDelay == true) { item -> interval = delay; }
    item -> elapsing = time() + item -> interval;
    this -> runList.insert (item);
  }

  //myScheduler() -> setMinTimer (*runList.readFirst());
  updMinTimerOfSch();		// *MJSII*
}
#endif /*1*/

#if 0
async TimerMan::lengthen (TimerId id, Time newInterval)
{
  TimerObj	*item = NULL;

  this -> runList.remove (item, id);
  if (item == NULL) {
    this -> stopList.remove (item, id);
  }

  if (item == NULL) {
    OTSO_WARNING( "Cannot lengthen. Timer " << id << " does not exist. " );
  } else {
    if (time() + newInterval > item -> elapsing) {
      item -> elapsing = time() + newInterval;
    }
    this -> runList.insert (item);
  }
}
#endif

Time TimerMan::timeLeft (TimerId id)
{
  TimerObj*	item = NULL;

  this -> runList.remove (item, id);
    //Should we check stopList?
  if (item == NULL) {
    OTSO_WARNING( "Timer " << id << " is not running; timeLeft() returns 0." );
    return 0;
  } else {
    this -> runList.insert(item);
    if ( item -> elapsing <= Time(0,0) ) { return item -> elapsing; }
    else { return item -> elapsing - time(); }
  }
}

async TimerMan::stop (TimerId id)
{
  TimerObj	*item = NULL;

  this -> runList.remove (item, id);
  if (item != NULL) {
    item -> elapsing = 0;
    this -> stopList.put (item);
  } else {
    OTSO_WARNING( "Timer " << id << " was not running." );
  }
#if 1
  updMinTimerOfSch();   // *MJSII*
#else
  if (runList.readFirst()) {
    myScheduler() -> setMinTimer (*runList.readFirst());
  }
#endif
}

async TimerMan::kill (TimerId id)
{
  TimerObj	*item = NULL;

  this -> runList.remove (item, id);
  if (item == NULL) {
    this -> stopList.remove (item,id);
  }

  if (item) {
    delete item;
    this -> timerObjCount--;
  } else {
    OTSO_WARNING("Cannot kill. Timer " << id << " does not exist. ");
  }
}

void TimerMan::run()
{
  TimerObj	*item = NULL;
  Time		curTime = time();
  boolean	changed = false;


  while ((this -> runList.readFirst() != NULL)
         && (*(this -> runList).readFirst() <= curTime)
  ) {
    // *MJS* changes above - jfr!
    item = (TimerObj*) this -> runList.get();
    item -> elapsing = 0;
    this -> stopList.put (item);
    if (trace.actions) {
      dout << "\nTimeout on timer " << item -> id
	   << ", sending timeout message\n";
    }
    item -> owner -> timeout(item -> id);
    changed = true;
  }

  if (changed) updMinTimerOfSch();	// *MJSII*

  if (inQ() && !inQ() -> isEmpty()) 
    Runner::run();	//handle a queued message

  runStatus = RunStatus::enabled;
}

void TimerMan::print (Ostream& os)
{ 
  os << INDENT << "TimerMan " << name() << "{\n"; os.addIndent(+2);
  os << INDENT << "number of timers: " << this -> timerObjCount << "\n";
  os << INDENT << "stopList " << this -> stopList << "\n";
  os << INDENT << "runList "  << this -> runList  << "\n";
  os.addIndent(-2); os << INDENT << "}\n";
}

void TimerMan::updMinTimerOfSch()
{
  if (runList.readFirst())
    myScheduler()->setMinTimer(*runList.readFirst());
  else {
    Time t;
    t.reset();  // not needed, but indicates the meaning of t
    myScheduler()->setMinTimer(t);
  }
}

#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class TimerMan
**********************************************************************/
TimerManPtr::TimerManPtr(TimerMan*,Object*) {
  OTSO_WARNING("TimerManPtr objects should not be created.");
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(TimerMan,
  ( OTSO_DATA_MEMBER(TimerList,runList,"")
   ,OTSO_DATA_MEMBER(TimerList,stopList,"")
   ,OTSO_DATA_MEMBER(sint32,timerObjCount,"the number of TimerObjs in lists ")
   ,OTSO_DATA_MEMBER(sint32,counter,"Running counter used for generating new TimerIds. ")
   ,OTSO_DATA_MEMBER(boolean,restartingFrom0,"False until counter has 'overflown'. Restarts counting from 0. ")
   ,OTSO_PUBLIC_BASE_CLASS(TimerSP,"")
   ,OTSO_PUBLIC_BASE_CLASS(Runner,"")
  ));

TimerMan::operator TimerSPPtr () {
  //called when connecting a local sp to Ptr
  TimerSPPtr ret((TimerSP*)this, (Object*)this);
  return ret;
}

#if 0
XXX& operator||(XXX& l, TimerMan& r) {
  l || (TimerSP&)r;
  l || (Runner&)r;
  l || r.runList;
  l || r.stopList;
  l || r.timerObjCount;
  l || r.counter;
  l || r.restartingFrom0;
  return l;
}
#endif

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/
