/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.memdbgSP.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:42
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
memdbgSP.hx
**********************************************************************/

#if DEBUGGING_FREE_STORE_MEMORY

/**********************************************************************
Services for debugging free store memory usage.
Typically these are called via the command interpreter (memoryWatchdog),  
but can be called from code as well.

Only the memory blocks handled by 'new' and 'delete'
are included in the list of memory blocks.  Memory blocks created
by malloc() are not seen in any way by these services.

Printing to dout or cout, especially for the first time,
may cause some internal buffer(s) to be allocated (e.g. 1024 bytes).  
Those memory blocks are shown by these services, 
but of course you need not worry about deleting them.

**********************************************************************/

/*interface*/ class MemoryDebugging { public: DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MemoryDebugging); private: 
public:
  virtual void	startWatching() = 0; 
                                //Start (or restart) watching 
                                //allocations and deallocations
                                //of free store memory blocks.
                                //This is slow: one second is spent
                                //before and after checking time
                                //(sleep(1)) to ensure that no memory
                                //blocks are allocated at the 
                                //'startWatching' time.
  virtual void	stopWatching() = 0;
                             	//Stop watching 
                                //allocations and deallocations
                                //of free store memory blocks.
                                //This is slow: one second is spent
                                //before and after checking time
                                //(sleep(1)) to ensure that no memory
                                //blocks are allocated at the 
                                //'stopWatching' time.
  virtual void	printBlocksAllocatedBetweenStartAndStop() = 0;
                                //Print memory blocks allocated but
                                //not deallocated after the latest
                                //start() and before the
                                //latest stop().
                                //Typically, call start(), then
                                //do a sequence of actions whose 
                                //memory consumption you are watching,
                                //then call stop() and,
                                //finally, call this.
  virtual void	trapNewAndDeleteOfBlock(sint32 number) = 0;
                                //Stop when the memory block with the
                                //given number is allocated.
                                //This should be run under a debugger,
                                //and there must be a breakpoint
                                //in ::debug().  You must first
                                //call this with a dummy number 0,
                                //do a sequence of actions whose
                                //memory consumption you are watching,
                                //and print the list of memory blocks.
                                //If you wish to catch the allocation and
                                //deallocation of a certain memory block,
                                //check from the listing the number of 
                                //the memory block.
                                //Then call this with the number of 
                                //the "interesting" memory block,
                                //and repeat the sequence of actions.

}; DECLARE_OTSO_PAED_FOR(MemoryDebugging); 

#endif /*DEBUGGING_FREE_STORE_MEMORY*/
#ifndef MemoryDebugging_OTSO_HXX
#define MemoryDebugging_OTSO_HXX

/**********************************************************************
  Generated by OTSO prepro for class MemoryDebugging
**********************************************************************/

/******** _in, _out, _msg macros for function prototypes ********/
/* Do not use both _in and parameter format for one function */

#define startWatching_in startWatching()
#define startWatching_out startWatching()
#define startWatching_msg MemoryDebugging_startWatching()
#define stopWatching_in stopWatching()
#define stopWatching_out stopWatching()
#define stopWatching_msg MemoryDebugging_stopWatching()
#define printBlocksAllocatedBetweenStartAndStop_in printBlocksAllocatedBetweenStartAndStop()
#define printBlocksAllocatedBetweenStartAndStop_out printBlocksAllocatedBetweenStartAndStop()
#define printBlocksAllocatedBetweenStartAndStop_msg MemoryDebugging_printBlocksAllocatedBetweenStartAndStop()
#define trapNewAndDeleteOfBlock_in trapNewAndDeleteOfBlock(sint32 number)
#define trapNewAndDeleteOfBlock_out trapNewAndDeleteOfBlock(number)
#define trapNewAndDeleteOfBlock_msg MemoryDebugging_trapNewAndDeleteOfBlock(number)

/*********** _interface macro *******************************/

#define MemoryDebugging_interface \
  void startWatching_in; \
  void stopWatching_in; \
  void printBlocksAllocatedBetweenStartAndStop_in; \
  void trapNewAndDeleteOfBlock_in

/*****************************************************************
MemoryDebugging interface object class 
*****************************************************************/
class MemoryDebugging_agent: public MemoryDebugging, public Agent {
  friend class MemoryDebuggingPtr;
private:
  MemoryDebugging* sPInterface_;
  virtual void setSPInterface(void* p); //if p==0, uses this
  MemoryDebugging_agent(MemoryDebugging* spI, Object* spO, Process* spP,
		Object* suO, Process* suP, Agent::AgentState s);
public:
  redefined MemoryDebugging_interface;
  MemoryDebugging* sPInterface();
  ~MemoryDebugging_agent(); //?
  virtual String className() const;
};

/*****************************************************************
MemoryDebuggingPtr is a kind of pointer to an OTSO Object that implements
MemoryDebugging.  It should be used instead of C++ a pointer (*) when
(concurrency-control or) messages are needed to provide support for
asynchronous message passing, tracing, or distribution.
MemoryDebuggingPtr is a "user interface" to MemoryDebugging
interface objects (MemoryDebugging_agent).  The agents contain pointers 
to the service provider (SP) and service user (SU) objects.
MemoryDebuggingPtr itself consists of two (?) pointers, so it is
not expensive to pass it as a pass-by-value argument in a function call.

Usage examples:
.nf
  SP sp;
  SU su;                  //contains MemoryDebuggingPtr ptr;
  su.ptr = sp;            //sp must have operator MemoryDebuggingPtr ()
.fi

MemoryDebugging* alone is not enough to build a MemoryDebuggingPtr, 
so assigning a MemoryDebugging* to an MemoryDebuggingPtr is not possible.
delete an MemoryDebuggingPtr is not possible!
C++ pointers should not be used in OTSO system logical description (*.str).

*****************************************************************/

class MemoryDebuggingPtr: public MultiPtr {
  friend class MemoryDebugging_agent;
  friend class MemoryDebugging_startWatching;
  friend class MemoryDebugging_stopWatching;
  friend class MemoryDebugging_printBlocksAllocatedBetweenStartAndStop;
  friend class MemoryDebugging_trapNewAndDeleteOfBlock;
private:
  MemoryDebugging_agent* dap;
  MemoryDebuggingPtr(sint8);	//Used by messages.
			//No agent allocated, setAgent() must be called soon.
  void setAgent(MemoryDebugging_agent*);
  void ifAgentIsSharedCreateANewOne();
public:
  MemoryDebugging* operator->();
  operator MemoryDebugging* ();
  MemoryDebuggingPtr& operator=(const String& spName);
  MemoryDebuggingPtr& operator=(const MemoryDebuggingPtr&);
			//SU part not changed!
  virtual String className() const;
  virtual Agent* agent();
  virtual void ask(Istream&);
  virtual void from(IDump&);
  MemoryDebuggingPtr();
			//Default constructor is used mainly by Runners that
			//have member Ptrs to other Runners.
			//By default SU is Runner::lastConstructedRunner.
			//If it is not ok, setAgent() should be called.
  MemoryDebuggingPtr(MemoryDebugging* i, Object* o);
			//Called from implementation class
			//operator MemoryDebuggingPtr().
  MemoryDebuggingPtr(const Agent& sp);
			//Called in main() when sp represents a remote object.
			//NO type checking -- cannot guarantee that sp
			//implements MemoryDebugging!!!
  MemoryDebuggingPtr(const MemoryDebuggingPtr&);
 ~MemoryDebuggingPtr();
};


/************** message class definitions *********/

/*****************************************************************
Start (or restart) watching  allocations and deallocations of free store memory blocks. This is slow: one second is spent before and after checking time (sleep(1)) to ensure that no memory blocks are allocated at the  'startWatching' time. 
*****************************************************************/
class MemoryDebugging_startWatching: public Message {
  friend class MemoryDebugging_agent;
private:
  MemoryDebuggingPtr otsoPtr;
  virtual Agent* agent(); //shares SU's MemoryDebuggingPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MemoryDebugging_startWatching);
public:
  Message* send();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  MemoryDebugging_startWatching();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  ~MemoryDebugging_startWatching(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_startWatching);

NewMsg* new_MemoryDebugging_startWatching(); //?

/*****************************************************************
Stop watching  allocations and deallocations of free store memory blocks. This is slow: one second is spent before and after checking time (sleep(1)) to ensure that no memory blocks are allocated at the  'stopWatching' time. 
*****************************************************************/
class MemoryDebugging_stopWatching: public Message {
  friend class MemoryDebugging_agent;
private:
  MemoryDebuggingPtr otsoPtr;
  virtual Agent* agent(); //shares SU's MemoryDebuggingPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MemoryDebugging_stopWatching);
public:
  Message* send();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  MemoryDebugging_stopWatching();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  ~MemoryDebugging_stopWatching(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_stopWatching);

NewMsg* new_MemoryDebugging_stopWatching(); //?

/*****************************************************************
Print memory blocks allocated but not deallocated after the latest start() and before the latest stop(). Typically, call start(), then do a sequence of actions whose  memory consumption you are watching, then call stop() and, finally, call this. 
*****************************************************************/
class MemoryDebugging_printBlocksAllocatedBetweenStartAndStop: public Message {
  friend class MemoryDebugging_agent;
private:
  MemoryDebuggingPtr otsoPtr;
  virtual Agent* agent(); //shares SU's MemoryDebuggingPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MemoryDebugging_printBlocksAllocatedBetweenStartAndStop);
public:
  Message* send();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  MemoryDebugging_printBlocksAllocatedBetweenStartAndStop();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  ~MemoryDebugging_printBlocksAllocatedBetweenStartAndStop(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_printBlocksAllocatedBetweenStartAndStop);

NewMsg* new_MemoryDebugging_printBlocksAllocatedBetweenStartAndStop(); //?

/*****************************************************************
Stop when the memory block with the given number is allocated. This should be run under a debugger, and there must be a breakpoint in ::debug().  You must first call this with a dummy number 0, do a sequence of actions whose memory consumption you are watching, and print the list of memory blocks. If you wish to catch the allocation and deallocation of a certain memory block, check from the listing the number of  the memory block. Then call this with the number of  the "interesting" memory block, and repeat the sequence of actions. 
*****************************************************************/
class MemoryDebugging_trapNewAndDeleteOfBlock: public Message {
  friend class MemoryDebugging_agent;
private:
  MemoryDebuggingPtr otsoPtr;
  virtual Agent* agent(); //shares SU's MemoryDebuggingPtr's agent
  virtual void run();
  DECLARE_OTSO_MEMBERS_FOR_THIS_CLASS(MemoryDebugging_trapNewAndDeleteOfBlock);
  /****** function arguments ******/
  sint32 number;
public:
  Message* send();
  virtual String className() const;
  virtual MultiPtr* multiPtr();
  virtual void outEncode(ODump&);
  virtual void outDecode(IDump&);
  MemoryDebugging_trapNewAndDeleteOfBlock();	//called by Istreams; they must 
			//call setSource(), setSourceName() and setDest().
  MemoryDebugging_trapNewAndDeleteOfBlock(sint32 number); //called by MemoryDebugging_agent
  ~MemoryDebugging_trapNewAndDeleteOfBlock(); //?
};

DECLARE_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_trapNewAndDeleteOfBlock);

NewMsg* new_MemoryDebugging_trapNewAndDeleteOfBlock(); //?

#endif
