/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.memdbgSP.hx
 * Vers: 5.2    Time: 92/08/04, 12:39:42
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
memdbgSP.hx
**********************************************************************/

#if DEBUGGING_FREE_STORE_MEMORY

/**********************************************************************
Services for debugging free store memory usage.
Typically these are called via the command interpreter (memoryWatchdog),  
but can be called from code as well.

Only the memory blocks handled by 'new' and 'delete'
are included in the list of memory blocks.  Memory blocks created
by malloc() are not seen in any way by these services.

Printing to dout or cout, especially for the first time,
may cause some internal buffer(s) to be allocated (e.g. 1024 bytes).  
Those memory blocks are shown by these services, 
but of course you need not worry about deleting them.

**********************************************************************/

interface class MemoryDebugging {
public:
  virtual void	startWatching() = 0; 
                                //Start (or restart) watching 
                                //allocations and deallocations
                                //of free store memory blocks.
                                //This is slow: one second is spent
                                //before and after checking time
                                //(sleep(1)) to ensure that no memory
                                //blocks are allocated at the 
                                //'startWatching' time.
  virtual void	stopWatching() = 0;
                             	//Stop watching 
                                //allocations and deallocations
                                //of free store memory blocks.
                                //This is slow: one second is spent
                                //before and after checking time
                                //(sleep(1)) to ensure that no memory
                                //blocks are allocated at the 
                                //'stopWatching' time.
  virtual void	printBlocksAllocatedBetweenStartAndStop() = 0;
                                //Print memory blocks allocated but
                                //not deallocated after the latest
                                //start() and before the
                                //latest stop().
                                //Typically, call start(), then
                                //do a sequence of actions whose 
                                //memory consumption you are watching,
                                //then call stop() and,
                                //finally, call this.
  virtual void	trapNewAndDeleteOfBlock(sint32 number) = 0;
                                //Stop when the memory block with the
                                //given number is allocated.
                                //This should be run under a debugger,
                                //and there must be a breakpoint
                                //in ::debug().  You must first
                                //call this with a dummy number 0,
                                //do a sequence of actions whose
                                //memory consumption you are watching,
                                //and print the list of memory blocks.
                                //If you wish to catch the allocation and
                                //deallocation of a certain memory block,
                                //check from the listing the number of 
                                //the memory block.
                                //Then call this with the number of 
                                //the "interesting" memory block,
                                //and repeat the sequence of actions.

};

#endif /*DEBUGGING_FREE_STORE_MEMORY*/
