/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.memdbgSP.cx
 * Vers: 5.2    Time: 92/08/04, 12:39:36
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)memdbgSP.cx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
memdbgSP.cx
**********************************************************************/

#include "OTSO.hxx"

#if ! DEBUGGING_FREE_STORE_MEMORY
#define OTSO_GENERATED_CODE_NOT_COMPILED
#endif

#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class MemoryDebugging
**********************************************************************/

/********** MemoryDebugging_agent *****************************/

String MemoryDebugging_agent::className() const {return "MemoryDebugging_agent";}

MemoryDebugging_agent::MemoryDebugging_agent(MemoryDebugging* spI, Object* spO, Process* spP,
			Object* suO, Process* suP, Agent::AgentState s)
     : Agent(spO, spP, suO, suP, s)
     , sPInterface_(spI)
{}

MemoryDebugging_agent::~MemoryDebugging_agent() {}

MemoryDebugging* MemoryDebugging_agent::sPInterface() {return sPInterface_;}

void MemoryDebugging_agent::setSPInterface(void* p) {
    //p==0 when only the name is known about sp (no type checking)
  sPInterface_ = ( p? (MemoryDebugging*)p : this );
}

/********** MemoryDebuggingPtr *****************************/

String MemoryDebuggingPtr::className() const {return "MemoryDebuggingPtr";}

MemoryDebuggingPtr::MemoryDebuggingPtr(const MemoryDebuggingPtr& i): dap(i.dap)
{
  if (dap) dap->Agent::connect();
}

MemoryDebuggingPtr::MemoryDebuggingPtr()
  : dap(new MemoryDebugging_agent(
      0
     ,0
     ,0
     ,Runner::lastConstructedRunner
     ,Runner::lastConstructedRunner? Runner::lastConstructedRunner->process() : 0
     ,Agent::notConnected))
{
  if (dap) dap->Agent::connect();
}

MemoryDebuggingPtr::MemoryDebuggingPtr(MemoryDebugging* i, Object* o)
  : dap(new MemoryDebugging_agent(
      i
     ,o
     ,o? o->process() : 0
     ,0
     ,0
     ,Agent::connectedToAnSP))
{
  if (o && o->inQ()) dap->state_ = Agent::connectedToAnAgent;
  dap->Agent::connect();
}

MemoryDebuggingPtr::MemoryDebuggingPtr(sint8) : dap(0) {}

MemoryDebuggingPtr::MemoryDebuggingPtr(const Agent& staticAgent) 
  : dap(new MemoryDebugging_agent(
      0
     ,0
     ,staticAgent.process()
     ,0
     ,0
     ,Agent::connectedToAnAgent /*notTypeChecked?*/))
{
  //Called in initialization for a remote sp, cannot call setSp yet.
  OTSO_WARNING("Cannot check if " << staticAgent.name() << " implements 'MemoryDebugging'.");
  dap->Agent::connect();
  dap->Agent::setName(staticAgent.name());
  dap->setDest((Agent*)dap, staticAgent.process()); //?
  dap->setSPInterface(dap); //?
}

MemoryDebuggingPtr::~MemoryDebuggingPtr() {
  if (dap) dap->Agent::disconnect();
}

Agent* MemoryDebuggingPtr::agent() {
  if (!dap)
    OTSO_WARNING("No agent connected to " << className() << ", returning 0 pointer");
  return dap;
}

void MemoryDebuggingPtr::setAgent(MemoryDebugging_agent* p) {
  if (dap == p) return;
  if (dap) dap->Agent::disconnect();
  dap = p;
  if (dap) dap->Agent::connect();
}

MemoryDebuggingPtr::operator MemoryDebugging* () {return operator->();}

MemoryDebugging* MemoryDebuggingPtr::operator->() {
  if (dap->state_ == Agent::connectedToAnAgent)
    return dap;
  else if (dap->state_ == Agent::notConnected) {
    MemoryDebugging_agent* ret = new MemoryDebugging_agent(
           dap
          ,dap->dest()
          ,dap->destProcess()
          ,dap->source()
          ,dap->sourceProcess()
          ,Agent::notConnected);
    ret->Agent::connect();
    return ret;
  }
  else {
    if (!dap->sPInterface_)
      OTSO_WARNING("MemoryDebuggingPtr::operator->() returns 0");
    if (!dap->dest())
      OTSO_WARNING("MgrSPPtr::operator->() : no dest Object, cannot set sender");
    else
      dap->dest()->setSender(dap);
    return dap->sPInterface_;
  }
}

void MemoryDebuggingPtr::ifAgentIsSharedCreateANewOne() {
  if (dap->useCount() > 1) {
    MemoryDebugging_agent* a = new MemoryDebugging_agent(*dap);
    dap->disconnect();
    dap = a;
    dap->connect();
  }
}

void MemoryDebuggingPtr::ask(Istream& is) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::ask(is);
}

void MemoryDebuggingPtr::from(IDump& id) {
  ifAgentIsSharedCreateANewOne();
  dap->Agent::from(id);
}

MemoryDebuggingPtr& MemoryDebuggingPtr::operator=(const String& spName) {
  ifAgentIsSharedCreateANewOne();
  dap->setSp(spName);
  return *this;
}

MemoryDebuggingPtr& MemoryDebuggingPtr::operator=(const MemoryDebuggingPtr& rhs) {
  if (dap == rhs.dap)
    ;
  else {
    MemoryDebugging_agent* r = rhs.dap;
    MemoryDebugging_agent* newDap = new MemoryDebugging_agent(
          r->sPInterface_
         ,r->dest()
         ,r->destProcess()
         ,dap? dap->source() : 0
         ,dap? dap->sourceProcess() : 0
         ,r->state_);
    if (dap) dap->Agent::disconnect();
    dap = newDap;
    if (dap->destProcess() != ::thisProcess) { //rhs is temporary
      dap->Agent::setDest((Agent*)dap, dap->destProcess());
      dap->setSPInterface((MemoryDebugging*)dap);
      dap->Agent::setName(r->Agent::name());
    }
#if SIMULATING
    setOtsoSimuDest(dap);
#endif
    dap->Agent::connect();
  }
  return *this;
}


/************** code for MemoryDebugging_startWatching ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_startWatching, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String MemoryDebugging_startWatching::className() const {return "startWatching";}

Message* MemoryDebugging_startWatching::send() {
  return (MemoryDebugging_startWatching*)sendAndReturnAValue();
}

Agent* MemoryDebugging_startWatching::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* MemoryDebugging_startWatching::multiPtr() {return &otsoPtr;}

void MemoryDebugging_agent::startWatching_in {
  MemoryDebugging_startWatching* otsoTmpMsg = new startWatching_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_MemoryDebugging_startWatching() {
  return new MemoryDebugging_startWatching;
}

void MemoryDebugging_startWatching::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->startWatching_out;
  sendReturnValue(this);
  return;
}

MemoryDebugging_startWatching::MemoryDebugging_startWatching() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(MemoryDebugging_startWatching*) defined
  setPriority(otsoRunnerPriority(this));
}

MemoryDebugging_startWatching::~MemoryDebugging_startWatching() {}


/************** code for MemoryDebugging_stopWatching ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_stopWatching, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String MemoryDebugging_stopWatching::className() const {return "stopWatching";}

Message* MemoryDebugging_stopWatching::send() {
  return (MemoryDebugging_stopWatching*)sendAndReturnAValue();
}

Agent* MemoryDebugging_stopWatching::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* MemoryDebugging_stopWatching::multiPtr() {return &otsoPtr;}

void MemoryDebugging_agent::stopWatching_in {
  MemoryDebugging_stopWatching* otsoTmpMsg = new stopWatching_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_MemoryDebugging_stopWatching() {
  return new MemoryDebugging_stopWatching;
}

void MemoryDebugging_stopWatching::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->stopWatching_out;
  sendReturnValue(this);
  return;
}

MemoryDebugging_stopWatching::MemoryDebugging_stopWatching() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(MemoryDebugging_stopWatching*) defined
  setPriority(otsoRunnerPriority(this));
}

MemoryDebugging_stopWatching::~MemoryDebugging_stopWatching() {}


/************** code for MemoryDebugging_printBlocksAllocatedBetweenStartAndStop ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_printBlocksAllocatedBetweenStartAndStop, 
 (OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::className() const {return "printBlocksAllocatedBetweenStartAndStop";}

Message* MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::send() {
  return (MemoryDebugging_printBlocksAllocatedBetweenStartAndStop*)sendAndReturnAValue();
}

Agent* MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::multiPtr() {return &otsoPtr;}

void MemoryDebugging_agent::printBlocksAllocatedBetweenStartAndStop_in {
  MemoryDebugging_printBlocksAllocatedBetweenStartAndStop* otsoTmpMsg = new printBlocksAllocatedBetweenStartAndStop_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_MemoryDebugging_printBlocksAllocatedBetweenStartAndStop() {
  return new MemoryDebugging_printBlocksAllocatedBetweenStartAndStop;
}

void MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->printBlocksAllocatedBetweenStartAndStop_out;
  sendReturnValue(this);
  return;
}

MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::MemoryDebugging_printBlocksAllocatedBetweenStartAndStop() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(MemoryDebugging_printBlocksAllocatedBetweenStartAndStop*) defined
  setPriority(otsoRunnerPriority(this));
}

MemoryDebugging_printBlocksAllocatedBetweenStartAndStop::~MemoryDebugging_printBlocksAllocatedBetweenStartAndStop() {}


/************** code for MemoryDebugging_trapNewAndDeleteOfBlock ********************/

IMPLEMENT_OTSO_PAED_FOR_OTSO_OBJECT(MemoryDebugging_trapNewAndDeleteOfBlock, 
 ( OTSO_DATA_MEMBER(sint32,number,"")
  ,OTSO_PUBLIC_BASE_CLASS(Object,"")
 ));

String MemoryDebugging_trapNewAndDeleteOfBlock::className() const {return "trapNewAndDeleteOfBlock";}

Message* MemoryDebugging_trapNewAndDeleteOfBlock::send() {
  return (MemoryDebugging_trapNewAndDeleteOfBlock*)sendAndReturnAValue();
}

Agent* MemoryDebugging_trapNewAndDeleteOfBlock::agent() {
  return otsoPtr.dap; //used to be: return otsoPtr.agent();
}

MultiPtr* MemoryDebugging_trapNewAndDeleteOfBlock::multiPtr() {return &otsoPtr;}

void MemoryDebugging_agent::trapNewAndDeleteOfBlock_in {
  MemoryDebugging_trapNewAndDeleteOfBlock* otsoTmpMsg = new trapNewAndDeleteOfBlock_msg;
  otsoTmpMsg->otsoPtr.setAgent(this);
  if (state_ == Agent::notConnected) {
    otsoTmpMsg->printAndDelete(dout);
    return;
  }
  otsoTmpMsg->sendAndReturnAValue();
  delete otsoTmpMsg;
} /*?*/

NewMsg* new_MemoryDebugging_trapNewAndDeleteOfBlock() {
  return new MemoryDebugging_trapNewAndDeleteOfBlock;
}

void MemoryDebugging_trapNewAndDeleteOfBlock::run() {
  dest()->setSender(otsoPtr.agent());
  otsoPtr.dap->sPInterface()->trapNewAndDeleteOfBlock_out;
  sendReturnValue(this);
  return;
}

MemoryDebugging_trapNewAndDeleteOfBlock::MemoryDebugging_trapNewAndDeleteOfBlock() {
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(MemoryDebugging_trapNewAndDeleteOfBlock*) defined
  setPriority(otsoRunnerPriority(this));
}

MemoryDebugging_trapNewAndDeleteOfBlock::~MemoryDebugging_trapNewAndDeleteOfBlock() {}

MemoryDebugging_trapNewAndDeleteOfBlock::MemoryDebugging_trapNewAndDeleteOfBlock(sint32 ddOTSOp0)
		: otsoPtr(0 /*no new agent*/)
		, number(ddOTSOp0)
{
  returnValueType_ = otsoType_void;
      //priority is Runner::defaultRunnerPriority 
      //unless otsoRunnerPriority(MemoryDebugging_trapNewAndDeleteOfBlock*) defined
  setPriority(otsoRunnerPriority(this));
}

void MemoryDebugging_trapNewAndDeleteOfBlock::outEncode(ODump& od) {
  //Most of these are empty inline functions.
  otsoOutEncode(od, &number);
}

void MemoryDebugging_trapNewAndDeleteOfBlock::outDecode(IDump& id) {
  //Most of these are empty inline functions.
  otsoOutDecode(id, &number);
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(MemoryDebugging,
  ( OTSO_METHOD_MEMBER(MemoryDebugging,startWatching,"Start (or restart) watching  allocations and deallocations of free store memory blocks. This is slow: one second is spent before and after checking time (sleep(1)) to ensure that no memory blocks are allocated at the  'startWatching' time. ")
   ,OTSO_METHOD_MEMBER(MemoryDebugging,stopWatching,"Stop watching  allocations and deallocations of free store memory blocks. This is slow: one second is spent before and after checking time (sleep(1)) to ensure that no memory blocks are allocated at the  'stopWatching' time. ")
   ,OTSO_METHOD_MEMBER(MemoryDebugging,printBlocksAllocatedBetweenStartAndStop,"Print memory blocks allocated but not deallocated after the latest start() and before the latest stop(). Typically, call start(), then do a sequence of actions whose  memory consumption you are watching, then call stop() and, finally, call this. ")
   ,OTSO_METHOD_MEMBER(MemoryDebugging,trapNewAndDeleteOfBlock,"Stop when the memory block with the given number is allocated. This should be run under a debugger, and there must be a breakpoint in ::debug().  You must first call this with a dummy number 0, do a sequence of actions whose memory consumption you are watching, and print the list of memory blocks. If you wish to catch the allocation and deallocation of a certain memory block, check from the listing the number of  the memory block. Then call this with the number of  the \"interesting\" memory block, and repeat the sequence of actions. ")
  ));

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/
