/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/gend/SCCS/s.memdbg.cx
 * Vers: 5.2    Time: 92/08/04, 12:39:33
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)memdbg.cx	5.2 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*
*	memdbg.cx
*
**********************************************************************/

#ifndef OTSO_HXX
#include "OTSO.hxx"
#endif

#if ! DEBUGGING_FREE_STORE_MEMORY
#define OTSO_GENERATED_CODE_NOT_COMPILED
#endif

#if DEBUGGING_FREE_STORE_MEMORY

static sint32	counter = 0;			//?
static sint32	latestIndex = 0;

/**********************************************************************/

boolean isOtsoFreeStorePointer(void* p) {
  MBlock*	mb = (MBlock*) ( (char*)p - sizeof(MBlock) );	//?
  char*		diagnostic = NULL;

  if (mb -> isBad(diagnostic))			//not all errors detected
    return false;
  else
    return true;				//?
}


// *MJS* changes affect time - jfr!
Time TIME() {
  if (thisProcess) {
    return thisProcess -> time();
  }
  else {
    return 0;
  }
}

/**********************************************************************/

void* MBlock::userBlock() const {
  return (char*)this + sizeof(MBlock);		//?
}

boolean MBlock::isTrapped() const {
  return ( ((*memoryWatchdog).numberTrapped() != 0)
           &&
           ( (*memoryWatchdog)[index_].ordinal_
	     ==
	     (*memoryWatchdog).numberTrapped()
	   )
	 );
}

void MBlock::setType(Type* t) {
  (*memoryWatchdog)[index_].otsoType_ = t;
}

void MBlock::set(size_t s) {
  index_ = (*memoryWatchdog).newIndex();
  ::latestIndex = index_;
  (*memoryWatchdog)[index_].set(this, s);
}

boolean MBlock::isBad(char*& diagnostic) const {
  static char*		badAddress = "Bad address";
  static char*		corrupted  = "Corrupted memory block";
  static char*		deleted    = "Memory block already deleted";

  if (this < MBlockInfo::smallestPointer ||
      this > MBlockInfo::biggestPointer) {
    diagnostic = badAddress;
    return true;
  }
  //delete(bad address) may cause a crash here!
  if (index_ <= 0 || index_ >= (*memoryWatchdog).size()) {
    diagnostic = corrupted;
    return true;
  }
  else if ((*memoryWatchdog)[index_].pointer() != this) {	//?
    diagnostic = deleted;
    return true;
  }
  else
    return false;
}

/**********************************************************************/

MBlock* MBlockInfo::smallestPointer = 0;
MBlock* MBlockInfo::biggestPointer = 0;

MBlockInfo::MBlockInfo() 
     : pointer_(0)
     , otsoType_(0)
     , object_(0)
{}

void MBlockInfo::set(MBlock* block, size_t s) {
  if (block) {
    pointer_ = block;
    if (block < smallestPointer || smallestPointer == 0)
      smallestPointer = block;
    if (block > biggestPointer || biggestPointer == 0)
      biggestPointer = block;
    size_ = s;
    birthTime_ = TIME();
    ordinal_ = ::counter++;
    if (memoryWatchdog)
      (*memoryWatchdog).incTotalSize(s);
  }
  else {
    if (pointer_ && memoryWatchdog)
      (*memoryWatchdog).incTotalSize(-size_);
    pointer_ = 0;
    size_ = 0;
    otsoType_ = 0;
  }
}

/**********************************************************************/

MBlockInfoArray* memoryWatchdog = 0;

// *MJS* changes - jfr! asciiTime() no longer needed

void MBlockInfoArray::startWatching() {
  sleep(1);		//no other events at the recorded moment of time
  this -> startingTime_ = TIME();
  sleep(1);
}

void MBlockInfoArray::stopWatching() {
  sleep(1);		//no other events at the recorded moment of time
  this -> stoppingTime_ = TIME();
  sleep(1);
}

void MBlockInfoArray::printBlocksAllocatedBetweenStartAndStop() {
  Ostream&		os = dout;	// ???
  os <<"\n***************************************************************************\n"
     << "*{ Free store memory blocks allocated (but not deleted) between\n" 
     << "*  "
     << this -> startingTime_.asctime()
     << " and " 
     << this -> stoppingTime_.asctime()
     << ":\n" ;
  printBlocksAllocatedBetween(os, this -> startingTime_, this -> stoppingTime_,"");
}

void MBlockInfoArray::trapNewAndDeleteOfBlock(sint32 number) {
  this -> numberTrapped_ = number;
}

sint32 MBlockInfoArray::newIndex() {
  for (sint32 i = current_; i < arraySize_; i++)
    if (!array_[i].pointer()) {
      current_ = i + 1;
      slotsInUse_++;
      return i;
    }
  for (i = 1; i < current_; i++)
    if (!array_[i].pointer()) {
      current_ = i + 1;
      slotsInUse_++;
      return i;
    }
  //array_ is full
  resizeArray(2*arraySize_);
  return current_;
}

const sint32 MBlockInfoArray::minimumBlockNumber = 200;

void MBlockInfoArray::deleteIndex(sint32 index) {
  array_[index].set(0, 0);
  slotsInUse_--;
#if 0
  if (arraySize_ > MBlockInfoArray::minimumBlockNumber && 
      slotsInUse_ < arraySize_/2-1 &&
      upperHalfOfArrayNotUsed()			//not implemented
     )
    resizeArray(arraySize_/2);
#endif
}

/*************************************************************************
When the array gets full, a new array is allocated. 
The old array is copied to the new one, and then deleted.

When shrinking, make sure that you preserve the indexes.
The upper half of the array must not be used at all.

Do not print anything here, Ostream overflow may cause allocation of more
memory and an infinite loop (?).
*************************************************************************/

void MBlockInfoArray::resizeArray(sint32 newSize) {
  MBlockInfo* newArray = 
    (MBlockInfo*)MBlockInfoArray::malloc(newSize * sizeof(MBlockInfo));	//?

  sint32 top = 0;
  if (newSize < this -> arraySize_) 
    top = newSize;
  else
    top = this -> arraySize_;

  for (sint32 i = 1; i < top; i++)
    newArray[i] = array_[i];
  this -> current_ = top;	  //newIndex starts looking from old arraySize_ on
  this -> arraySize_ = newSize;
  MBlockInfoArray::free(this -> array_);
  this -> array_ = newArray;
}

void MBlockInfoArray::print(Ostream& os) {
  os <<"\n***************************************************************************\n"
     << "* Free store memory blocks watched by OTSO: {\t\t\t\n";
  printBlocksAllocatedBetween(os, 0, TIME() /*?*/ , "");
}

void MBlockInfo::print(Ostream& os) {
  os << "*"; 
  os.width(8);	os << ordinal_;
  os.width(10);	os << (long)pointer_ -> userBlock();
  os.width(7);	os << size_;
  os << "  " << birthTime_.asctime() << "  ";
  if (object_) {
    if (object_ -> className() != object_ -> name()) 
      os << object_ -> className() << " ";
    os << object_ -> name();
    if (object_ -> className() == "String")
      os << " \"" << *object_ << "\"";
  }
  os << "\n";
}

void MBlockInfoArray::printBlocksAllocatedBetween(
  Ostream&	os, 
  Time		start,
  Time		stop,
  char*		/*heading*/
) {
  if (start >= stop)
    OTSO_WARNING("Give command '*memoryWatchdog stop' to get a reasonable time range");
  sint32	total = 0;
  MBlockInfo	*mbi = 0;

  os << "*\n"
     << "*  Number   Address   Size     Time of allocation     (Contained Object)\n"
     << "*  ------   -------   ----  ------------------------  ------------------\n" ;
  for (sint32 i = 0; i < arraySize_; i++) {
    mbi = &array_[i];
    if (mbi -> pointer())
      if (mbi -> birthTime() >= start)
	if (mbi -> birthTime() <= stop)
	  {
	    mbi -> print(os);
	    total += mbi -> size();
	  }
  }
  os << "*\t\t\t\t\t\t\t\n"
     << "* Total size of these memory blocks: " 
     << total << " bytes." ;
  if (total == 0) { os << "  FINE!"; }
  os << "\n*}*************************************************************************\n\n";
}

MBlockInfoArray::MBlockInfoArray()
     : array_((MBlockInfo*)MBlockInfoArray::malloc(
	      MBlockInfoArray::minimumBlockNumber * sizeof(MBlockInfo))) //?
     , arraySize_(MBlockInfoArray::minimumBlockNumber)
     , slotsInUse_(0)
     , current_(1)
     , totalSize_(0)
     , numberTrapped_(0)
     , startingTime_(0)
     , stoppingTime_(0)
     , warnAboutDelete0(false)
     , showNewAndDelete(false)
{
  for (sint32 i = 0; i < arraySize_; i++)
    array_[i].set(0, 0);
}

/**********************************************************************/

void* MBlockInfoArray::operator new(size_t s) {
  return malloc(s);
}

void MBlockInfoArray::operator delete(void*p) {
  free(p);
}

void* MBlockInfoArray::malloc(size_t s) {
  void*		p = ::malloc(s);
  if (memoryWatchdog && (*memoryWatchdog).showNewAndDelete && doutStream)
    dout << "\t" << (long)p << "+\tmalloc(" << s << ")\n";
  return p;
}

void MBlockInfoArray::free(void* p) {
  if (memoryWatchdog && (*memoryWatchdog).showNewAndDelete && doutStream)
    dout << "\t" << (long)p << "-\tfree(" << (long)p << ")\n";
  ::free(p);
}

MBlock* newMBlock(size_t userBlockSize) {
  //I had problems with MBlock::operator new(size_t MBlock, size_t type).
  //Therefore memory is allocated and "constructed" here.
  MBlock* mb = (MBlock*)MBlockInfoArray::malloc(userBlockSize + sizeof(MBlock));
  if (!mb) {
    OTSO_ERROR( "Out of memory, could not allocate " << userBlockSize << " bytes of free store. 0 pointer returned" );
    //Memory::lowOnMemory = true;
    //free a spare block, try again, or just ...
    return 0;					//?
  }
  else {
    mb -> set(userBlockSize);
    return mb;
  }
}

void* operator new(size_t s) {
  if (!memoryWatchdog) {
    memoryWatchdog = new MBlockInfoArray;
  }

  MBlock*	mb = newMBlock(s);
  if (!mb) { return 0; }	// ???
  if (mb -> isTrapped()) {
    dout << "***** The specified MBlock was just allocated\n";
    ::debug();
  }
  return mb -> userBlock();
}

/*Object constructor is only concerned with free store memory debugging*/
Object::Object() {
  //see ::operator new() !
  if (::latestIndex) {
    MBlockInfo& mbi = (*memoryWatchdog)[::latestIndex];
    if ((void*)this == mbi.pointer() || 
	mbi.pointer() < (void*)this && 
	(void*)this < (char*)mbi.pointer() + mbi.size()
	) {
	  mbi.setObject(this);
	  ::latestIndex = 0;
	}
  }
}

void deleteMBlock(MBlock* mb) {
  //I had problems with MBlock::operator new(size_t MBlock, size_t type).
  //Therefore MBlock is "destructed" and deallocated here.
  (*memoryWatchdog).deleteIndex(mb -> index_);
  //mb -> index_ = 0;	   //not assigned 0 => can usually make a difference 
                           //between
                           //multiple deleting and deleting bad address
  MBlockInfoArray::free(mb);
}

void operator delete(void* p) {	
  if (!p) {
    if ((*memoryWatchdog).warnAboutDelete0)
      OTSO_WARNING( "delete(0), nothing deleted" );
    return;
  }
  MBlock* mb = (MBlock*) ( (char*)p - sizeof(MBlock) );	//?
  char* diagnostic;
  if (mb -> isBad(diagnostic)) {		//not all errors detected
    OTSO_ERROR(diagnostic);
    OTSO_ERROR("Cannot delete(" << (long)p << ")\n" );
  }
  else {
    if (mb -> isTrapped()) {
      dout << "***** Deleting the specified MBlock\n";
      ::debug();
    }
    deleteMBlock(mb);
  }
}

#endif

#ifndef OTSO_GENERATED_CODE_NOT_COMPILED
/**********************************************************************
  Generated by OTSO prepro for class MBlockInfoArray
**********************************************************************/
MBlockInfoArrayPtr::MBlockInfoArrayPtr(MBlockInfoArray*,Object*) {
  OTSO_WARNING("MBlockInfoArrayPtr objects should not be created.");
}

IMPLEMENT_OTSO_PAED_DEFAULTS_FOR(MBlockInfoArray,
  ( OTSO_DATA_MEMBER(boolean,warnAboutDelete0,"When true, a warning is printed delete() argument is 0. 0 argument for delete() is perfectly legal: delete() does nothing, but you may wish to avoid the extra time spent by calling delete(0). ")
   ,OTSO_DATA_MEMBER(boolean,showNewAndDelete,"When true, trace is printed at every new and delete operation.  Verbose! ")
   ,OTSO_PUBLIC_BASE_CLASS(MemoryDebugging,"")
  ));

MBlockInfoArray::operator MemoryDebuggingPtr () {
  //called when connecting a local sp to Ptr
  MemoryDebuggingPtr ret((MemoryDebugging*)this, (Object*)this);
  return ret;
}

#if 0
XXX& operator||(XXX& l, MBlockInfoArray& r) {
  l || (MemoryDebugging&)r;
  l || r.warnAboutDelete0;
  l || r.showNewAndDelete;
  return l;
}
#endif

#endif /*OTSO_GENERATED_CODE_NOT_COMPILED*/
