/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.fifo.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:08
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)fifo.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	fifo.cxx
*
* PURPOSE
*	A "first in, first out" container class (group) for OTSO.
*	The fifo is a fifo of Runners.
*
* MODIFICATIONS
* BUGS
**********************************************************************/

#define AGENT_HXX	1	/*inline Message::destProcess()*/
#define CHANNEL_HXX	1	/*runUI*/
#define FIFO_HXX	1
#define GROUP_HXX	1
#define MESSAGE_HXX	1	/*runUI*/
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1	/* *MJS* changes - jfr! */
#define TYPE_HXX	1
#define VOIDGRP_HXX	1	/*runUI*/

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /**** dout << "### fifo.cxx - " << xxx << "\n"; dout.flush(); ****/


/**
 ** class Fifo 
 **/

String Fifo::className() const {return "Fifo";}

Fifo::Fifo() {
  fst = last = NULL;
}

Fifo::~Fifo() {
  GE e;
  do {
				//get all elements to delete Links.
                                //GEs are NOT deleted automatically!
    get(e);
  } while (e != (GE)&dummyRunner);
}

Group& Fifo::myGet(GE& o) {
  Link*	l = fst;
  if (l==NULL)
    o = (GE)&dummyRunner;
  else {
    o = (GE)l->element;
    fst = fst->next;
    delete l;
    size_--;
  }
  return *this;
}

Group& Fifo::myPut(const GE o) {
  Link *l = new Link(o, NULL);
  if (fst==NULL) fst = l;
  else last->next = l;
  last = l;
  size_++;
  return *this;
}

GE Fifo::first(GP& link) {
  if (fst == NULL) {
    return ((GE)(link = &dummyRunner));	
  } else {
    return ((Link*)(link = fst))->element;
  }
}

GE Fifo::next(GP& link) {
  return (link == NULL || (link = ((Link*)link)->next) == NULL)?
    &dummyRunner : ((Link*)link)->element;
}


/**
 ** class Lifo
 **/

Group& Lifo::myPut(const GE o) {
  Link *l = new Link(o, NULL);
  if (fst==NULL) fst = l;
  else l->next = fst;
  fst = l;
  size_++;
  return *this;
}

Lifo::Lifo() {}

/**********************************************************************/

const sint32 MemberObjectList::ambiguityLimit = 0x0FFFFFFF/1000;

MemberObjectList::MemberObjectList()
     : memberCount(0)
     , isWildCardUsed(false)
{}

boolean	MemberObjectList::isAmbiguous() const {
  return memberCount > ambiguityLimit;
}

MemberObjectList& MemberObjectList::insert(Runner* mb) {
  put(mb); 
  return *this;
}

void MemberObjectList::addCount(sint32 n) {
  memberCount += n;
}

              /*returns 0 or MemberObjectList (of return values)*/
Member MemberObjectList::runUI(Objectifier sp, String prompt, String memberName) {
  BUGOUT( "MemberObjectList::runUI(" << sp << ", " << prompt << ", " << memberName << ")" );
  BUGOUT( "LIST=<<<" << *this << ">>>" ); 

  //If not given, read one memberName to be given to all members in this list.
  //Do not read if this list contains a Message element.

  //if (!memberNameWasGivenByCaller)
  if (memberName.isEmpty() && 
      memberCount < ambiguityLimit &&
      memberCount > 1
      ) {
    if (!dinStream->isReadyToRead())
      dout << prompt << *this << " " << "OPERATION: ";
    din >> memberName;
    if (!din) {OTSO_WARNING( "Bad input\n" ); return 0;}
  }

  FOR_EACH_runner_IN(*this) {
    //here runners are Objectifiers or Messages.
    //spObject used only by Messages, handlerPart used only by Objectifiers.

    //tell the user what is happening
    dout << runner->name() << " " << memberName << ": ";

    if (memberCount == 1)
      runner->runUI(runner, prompt, "_OTSO_Unique_match_" /*!1*/);
    else {

      Filebuf* fb = (Filebuf*)dinStream->rdbuf();	//risky!?
      fb->putBack(memberName + " \n");

      runner->runUI(runner, prompt, memberName /*!1*/);
    }

    delete runner;
    if (!din) {OTSO_WARNING( "Bad input\n" ); return 0;}
    dout << "\n";    //put something between print() outputs!
  }

  return 0;
}

