/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.dyndir.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:06
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)dyndir.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
*
* NAME
*	dyndir.cxx 
*
* PURPOSE
*	see dyndir.hxx

* BUGS
*       The current implementation is inefficient.
* MODIFICATIONS
* *SPARC* ::namedObj
*
**********************************************************************/


#define CHANNEL_HXX	1
#define DYNDIR_HXX	1
#define GROUP_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define RUNNER_HXX	1	/*Objectifier*/
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TIME_HXX	1
#define TYPE_HXX	1
#define VOIDGRP_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */



NamedObj *dummyNamedObj = NULL;	// declared extern in object.hxx
				// initialized in init2.inc

DynDir	*namedObjs;	//directory of namedObjs for which a name has been set

/**********************************************************************/

String DynDir::className() const {return "DynDir";}

NamedObj* DynDir::pointer(String& n) {
  FOR_EACH_voidp_IN(*this)
    if (((NamedObj*)voidp)->name_ == n)
      return (NamedObj*)voidp;
  return ::dummyNamedObj; 
}

void* DynDir::servicePointer(String spName, String serviceName, Object*& sp) {
  NamedObj* n = this->pointer(spName);
  if (n == ::dummyNamedObj) 
    return 0;
  //spName exists
  sp = n;
  Objectifier o = n;
  void* ret = n->memberPointer(serviceName);
  return ret;
}

void DynDir::selectElementsWithMember(String memberName, Group& q) {
  NamedObj* n;
  FOR_EACH_voidp_IN(*this) {
    n = (NamedObj*)voidp;
    if ((n->memberPointer(memberName)) != 0)
      q.put((Runner*)n);		//risky type cast!?
  }
}


void DynDir::print(Ostream& os) {
  const uint16 elementsPerLine = 9999; 
  uint16 i = 0;
  os << "(";
  FOR_EACH_voidp_IN(*this) {
    NamedObj* no = (NamedObj*)voidp;
    os << no->name();         // *no is too verbose
    if (++i < elementsPerLine)
      os << " ";
    else {
      os << "\n";
      i = 0;
    }
  }
  os << ")";
}

void DynDir::insert(NamedObj* o) {
  VGP link; 
  for (void* elem = (*this).first(link); 
       !(*this).over(link); 
       elem = (*this).next(link)) {
         if (((NamedObj*)elem)->name() == o->name()) {
           ((VoidLink*)link)->element = o;	//replace
           return;
         }	
       }
  //a new name, insert
  VoidFifo::put(o);
}
