/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.corout.cxx
 * Vers: 5.1    Time: 92/08/04, 15:19:48
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)corout.cxx	5.1 92/08/04";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


//corout.cxx	- Juha 18.3.92

/**********************************************************************
This file is a modified version of cor.cxx
**********************************************************************/

#ifndef OTSO_HXX
#include "OTSO.hxx"
#endif

#if SIMULATING	/*up to the end of file*/

#ifndef LWP_EXT
#include "lwp.ext"	/* OTSO lwp definitons/externs ... */
#endif

#ifndef COROUT_HXX
#include "corout.hxx"
#endif

#define OTSO_BUGOUT(XXX) /*dout << XXX ;*/

void CorSU::testingIfThisReducesSpaceConsumption() {} //?

typedef void (*CorInitFnType)();		//?

static void	corInit(CorMan* man, CorSU* su)
{
  OTSO_BUGOUT("@@@ corInit(" << man->name() << ", " << su->corName() << ")\n");
	man->corBase(su);
}

void CorMan::print(Ostream& os) {
  os << "CorMan : {\n"
    << "  count " << count << "\n"
    << "  cix   " << cix << "\n"
    << "  yieldAllowed " << yieldAllowed << "\n"
    ;
  for (int i = 0; i < count; i++) {
    os	<< "  ci[" << i << "] {status " << ci[i].status;
    os	<< ", tid {thread_id*=(0x" << ci[i].tid.thread_id;
    os	<< (long)ci[i].tid.thread_id ;
    os	<< ", thread_key " << int(ci[i].tid.thread_key) << "}, corSU ";
    os	<< int(ci[i].corSU);
    if (ci[i].corSU) os << " " << ci[i].corSU->corName();
    os << "}\n";
  }
  os << "\n";
}

uint16 CorMan::getCorId()
{
	uint16	i;

	// coroutine #0 has been reserved for main scheduler...
	for (i = 1; i < MAX_THREADS; i++)
		switch (ci[i].status) {
		    case corFree     : return i;
		    case corInUse    : break;
		    case corObsolete :
			destroy(i);
			return i;
		}

	OTSO_ERROR("CorMan::getCorId(); internal coroutine table full");
	exit (1);
}

void CorMan::checkYield()
{
	static boolean	first = true;

	if (!yieldAllowed) {
#if TRACING
		if (first) {
		  if (trace.actions)
			dout << "corman: coroutine #" << cix
			     << " [" << corName(cix) << "] exited"
			     << " - execution of threads stopped\n";
		  //first = false;	//Juha commented out for debugging?
		}
#endif
		exit (0);
	} else
		yieldAllowed = false;
}

void CorMan::destroy(uint16 ix)
{
	if (ci[ix].status != corFree) {

		--count;
		ci[ix].status = corFree;
#if TRACING
		if (trace.actions)
		  dout << "corman: coroutine #" << ix
		       << " [" << corName(ix) << "] killed\n";
#endif
		OTSO_BUGOUT("@@@ lwp_destroy(#" << ix << ")\n");
		::lwp_destroy(ci[ix].tid);
	}
}

CorMan::CorMan()
{
	for (int i = 0; i < MAX_THREADS; i++)
		ci[i].status = corFree;

	count = 0;
	cix   = 0;
	yieldAllowed = false;
}

#if 0	/*Juha debugging*/

typedef void(*ThreadFn)();

void corExtraBody1(CorMan* a1, CorSU* a2) { //juha testing
  printf("corExtraBody1 here!\n");
  printf("a1 = %d, a2 = %d\n", a1, a2);
}

void corExtraBody2() { //juha testing
  printf("corExtraBody2 here!\n");
}

void print(thread_t& tt) {
  printf("  thread_t = {thread_id=%s (%d), thread_key=%d\n", tt.thread_id, (int)tt.thread_id, tt.thread_key);
}

int juhaTest(ThreadFn fp) {
  printf("exit juhaTest now? (0/1) ");
  int yes;
  scanf("%d", &yes);
  if (yes)
    return 1;

  static int first = true;
  if (first) {
    printf("call lwp_setstkcache()? (0/1) ");
    int yes;
    scanf("%d", &yes);
    if (yes)
      ::lwp_setstkcache(4000, MAX_THREADS);
    first = false;
  }
  printf("@@@ juhaTest(%d), calling lwp_create\n", (long)fp);
  thread_t tt;
  int notOK = ::lwp_create(&tt, fp, 1, 0, ::lwp_newstk(), 0);
  if (notOK) printf("*******lwp_create() failed.\n");
  print(tt);
  
  printf("@@@ now calling EXTRA lwp_yield (jumping to fp)\n");
  notOK = ::lwp_yield(tt);	
  printf("@@@ end of the started thread (fp), back in juhaTest\n");
  if (notOK) { 
    printf("lwp_yield(tt) failed because: lwp_errno=%d",notOK);
    lwp_perror("***** lwp_perror : ");
    print(tt);
  }
  return 1;
}

//int testi1 = juhaTest((ThreadFn)corExtraBody1);
//int testi2 = juhaTest(corExtraBody2);
#endif

uint16 CorMan::corNew(CorSU* su)
{
	if (!count) {	// initialize coroutine 0 for main level
		::lwp_self(&ci[0].tid);
		ci[0].status = corInUse;
		::lwp_setstkcache(4000, MAX_THREADS);
		++count;
#if TRACING
		if (trace.actions)
		  dout << "corman: coroutine #0"
		       << " [" << corName(0) << "] starts {\n";
#endif
		yieldAllowed = false;
	}

	if (count >= MAX_THREADS) {	// *E*	
		OTSO_ERROR("CorMan::CorMan(); too many coroutines");
		exit (1);
	}

	uint16 ix = getCorId();

  //dout << "@@@ About to call lwp_create. Before that, calling juhaTest\n";
  //juhaTest(corExtraBody2);

	int notOK = ::lwp_create(&ci[ix].tid, (CorInitFnType)/*?*/corInit, 
				 1, 0, ::lwp_newstk(), 2, this, su);
	if (notOK) OTSO_ERROR("lwp_create() failed, #" << ix);
  OTSO_BUGOUT("@@@ lwp_create called for " << su->corName() << ", #" << ix << "\n");

	ci[ix].status = corInUse;
	ci[ix].corSU  = su;	
	++count;

  OTSO_BUGOUT("@@@ lwp_create done.  calling juhaTest\n");
  OTSO_BUGOUT(juhaTest(corExtraBody2));

	return ix;
}

String CorMan::corName(uint16 ix)
{
	if (!ix)
		return scheduler->name();
	else
		return ci[ix].corSU->corName();
}

void CorMan::corJump(uint16 ix)
{
        if (cix == ix) return;

        if (ci[ix].status != corInUse) {
                OTSO_ERROR("CorMan::corJump(); jumping to non-existing coroutine #" << ix );
		exit (1);
	}

#if TRACING
	if (trace.actions)
	  dout << "corman: coroutine #" << cix
	       << " [" << corName(cix) 
	       << "] suspends }\n";   //'}'matches "starts {" and "resumes {"
#endif
	yieldAllowed = true;
	uint16 previousCix = cix;			//Juha added
	cix 	     = ix;


	OTSO_BUGOUT("@@@ corExtraBody1: &=" << (long)&corExtraBody1 << "\n");
	OTSO_BUGOUT(juhaTest( (ThreadFn)corExtraBody1) << " ");

 
	int notOK = ::lwp_yield(ci[ix].tid);
	if (notOK) {					//Juha added
	  OTSO_ERROR("lwp_yield(#" << ix << ") failed because: lwp_errno=" << int(notOK));
          lwp_perror("***** lwp_perror : ");
	  dout << className() << " " << name() << ": ";
	  print(dout);
	  cix = previousCix;
	}

	checkYield();

#if TRACING
	if (trace.actions)
	  dout << "corman: coroutine #" << cix
	       << " [" << corName(cix) << "] resumes {\n";
#endif
}

void CorMan::corDelete(uint16 ix)
{
	// If we are currently running this, we'll just make
	// this obsolete and destroy it later.
	if (cix == ix) {
		ci[ix].status = corObsolete;
		return;
	} else
		destroy(ix);
}

void CorMan::corBase(CorSU* su)
{
	checkYield();
#if TRACING
	if (trace.actions)
	  dout << "corman: coroutine #" << su->corId()
	       << " [" << su->corName() << "] starts {\n";
#endif
	OTSO_BUGOUT("@@@ corBase() calling " << su->corName() << "->corRun()\n")
	su->corRun();
	OTSO_BUGOUT("@@@ corBase(): " << su->corName() << "->corRun() completed\n");

	// id may now be used for another coroutine
	corDelete(su->corId());

	// class CorSU defines control to be returned to coroutine 0
	corJump(0);
	OTSO_BUGOUT("@@@ ??? corBase(" << su->corName() << ") continuing after corJump(0)\n");

	// this is an obsolete coroutine id of which has not been reused
	// yield to this coroutine is illegal, produce error message...
	yieldAllowed = false;
	checkYield();
}


#endif	/*SIMULATING*/
