/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.cframef.c
 * Vers: 5.3    Time: 92/08/13, 11:54:02
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)cframef.c	5.3 92/08/13";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/



/* 
 * TAKEN from old DVOPS:
 * (when we moved to Sparc Station and GNU G++ 2.0)
 *  Name:	/files/dvops/dvops/SCCS/s.cframef.c
 *  Version:	1.1
 *  Time:	89/11/13, 13:46:51
 */

/**************************************************************
*
* NAME
*	cframef.c
*
* PURPOSE
*	used to simulate missing CVOPS functions needed by
*	frame.c (DVOPS uses the same frame.c as CVOPS).
*
* SERVICE
* BUGS
* MODIFICATIONS
*
********************************************************************/


#include "frame.typ"

/* frame.typ */
#define DB_SIZE	128

#define DVOPS 1



extern FRAME* createFrame();
extern char* walloc();
#if MSDOS && TURBOC
#include <mem.h>
#else
extern void memcpy();
#endif

void putBlockToFrame (frameAddr, block, length)
FRAME **frameAddr;
BYTE_TYPE *block;
int length;
{
FRAME* frame;
DATA_BLOCK *db;

  frame = *frameAddr;
  if (frame == NULL)
    frame = createFrame(DB_SIZE);

  db = (DATA_BLOCK *)walloc(sizeof(DATA_BLOCK));
  db->next = frame->first;
  db->size = length;
  db->data = block;
  db->n = length;
  db->i = 0;
  db->j = length-1;
  frame->first = db;
}

void copynBytesToArray(frame,bytes,n)
FRAME *frame;
BYTE_TYPE *bytes;
int n;
{
DATA_BLOCK *db;
int x;

if (frame != NULL)
  for (db=frame->first; db!=NULL && n>0; db = db->next)
    {
      x = (n < db->n) ? n : db->n;
      memcpy(bytes,&db->data[db->i],x);
      n = n - x;
      bytes += x;
    }
return;
}



BYTE_TYPE *byteAddress (frame,n)
FRAME *frame;
int n;
{
  DATA_BLOCK *db;
  int s;

  if (frame && n>0 && n <= frame->length){
    db = frame->first;
    for (s=0; n>(s += db->n); db=db->next);
    return (&(db->data[db->j -(s-n)]));
  }
  else
     return(NULL);

}

