/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/dvops/SCCS/s.agent.cxx
 * Vers: 5.2    Time: 92/08/03, 13:33:01
 **************************************************************/

#ifdef SCCS_ID
/* for Unix 'what' command */
static char sccs_id[] = "@(#)agent.cxx	5.2 92/08/03";
#endif

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


/**********************************************************************
* NAME
*	agent.cxx
*
* PURPOSE
* MODIFICATIONS
* BUGS
**********************************************************************/

// The following #defines specify which header files to include.
#define AGENT_HXX	1
#define CHANNEL_HXX	1
#define DYNDIR_HXX	1
#define GROUP_HXX	1
#define FIFO_HXX	1
#define MULTI_HXX	1
#define NAMEDOBJ_HXX	1
#define OBJECT_HXX	1
#define PROCESS_HXX	1
#define RUNNER_HXX	1
#define SAMPLED_HXX	1
#define STATOBJ_HXX	1
#define STRING_HXX	1
#define TYPE_HXX	1
#define TIME_HXX	1
#define VOIDGRP_HXX	1

#define OTSO_SELECT_INCLUDES	1 /* take only these headers */
#include "OTSO.hxx"	/* include them now */


/* OTSO tool debugging tracing */
#define BUGOUT(xxx)  /**** dout << "### agent.cxx - " << xxx << "\n"; ****/

/**********************************************************************/

EnumInfo AgentAgentStateInfo [] = {
  {"notConnected", Agent::notConnected},
  {"connectedToAnAgent", Agent::connectedToAnAgent},
  {"connectedToAnSP", Agent::connectedToAnSP},
  {0,0}
};
IMPLEMENT_OTSO_PAED_FOR_ENUM(Agent,AgentState)

/*****************************************************************/

String Agent::className() const {return "Agent";}

Agent::Agent(Process* spP)
     : spObject(0)
     , spProcess(spP)
     , suObject(0)
     , suProcess(0)
     , state_(Agent::notConnected)
     , useCount_(0)
{}

Agent::Agent(Object* spO, Process* spP, 
	 Object* suO, Process* suP, Agent::AgentState s)
     : spObject(spO)
     , spProcess(spP)
     , suObject(suO)
     , suProcess(suP)
     , state_(s)
     , useCount_(0)
{}

Agent::Agent(const Agent& i) 
     : NamedObj(i)
     , spObject(i.spObject)
     , spProcess(i.spProcess)
     , spConId(i.spConId)
     , suObject(i.suObject)
     , suProcess(i.suProcess)
     , suConId(i.suConId)
     , sourceName_(i.sourceName_)
     , useCount_(0)			//!
     , state_(i.state_)
{}

Agent::~Agent() {}   //explicit in order to avoid duplication in executable (?)

void Agent::connect() {
  useCount_++;
}

void Agent::disconnect() {
  useCount_--;
  if (useCount_ < 0)
    OTSO_ERROR("OTSO internal error: " << className() << "::useCount_ == " << useCount_);
  if (useCount_ == 0) {
    delete this;			//virtual
  }
}

sint16 Agent::useCount() const {
  return useCount_;
}

Process*& Agent::process() const {
  if (!spProcess)
    OTSO_WARNING( "Agent::process() returns 0." );
  return spProcess;
}

void Agent::setSource(Object* suO, Process* suP) {
  if (useCount_ > 1 && suObject)
    OTSO_WARNING( "Agent::setSource modifies a shared instance of " << className() << " (shared by " << useCount_ << " Ptrs)" );
  suObject = suO;
  suProcess = suP;
}

void Agent::setDest(Object* spO, Process* spP) {
  if (useCount_ > 1)
    OTSO_WARNING( "Agent::setDest modifies a shared instance of " << className() << " (shared by " << useCount_ << " Ptrs)" );
  spObject = spO;
  spProcess = spP;
}

void Agent::setSPInterface(void* p) {
  OTSO_WARNING( "Agent::setSPInterface(" << (long)p << ") called" );
}

String Agent::sourceName() const {
  if (suObject)
    return suObject->name();
  else
    return sourceName_;
}

void Agent::setSourceName(const String& n) {
  sourceName_ = n;
}

Object* Agent::source() const {
  //if (!suObject) OTSO_WARNING( className() << "::source() : unknown source, returning 0");
  return suObject;
}

/**********************************************************************/

VoidPointer Agent::memberPointer(String memberName) {
  return Object::memberPointer(memberName);
}

#if 0
#include "inta.hxx" /* => Object::memberPointer may work incorrectly (?)*/
  if (className() == "Agent") {
    //move this (and previous #includes) to Agent::memberPointer()
    ObjectPtr p(*(Agent*)this);
    p.agent()->setSource(this, ::thisProcess); 
    p.agent()->setSourceName(name());
    dout << "@@@@@ Sending memberPointer to " << p << "\n";
    VoidPointer ret = p->memberPointer(memberName);
    if (ret)
      dout << "@@@@@ YES, has member " << memberName << "\n";
    else
      dout << "@@@@@ NO, no member " << memberName << "\n";
    return ret;
  }
#endif

/**********************************************************************/

void Agent::print(Ostream& os) {
  os << "{";

  if (suObject) {
    os << " from ";
    if (suProcess && suProcess != ::thisProcess)
      os << suProcess->name() << ":";
    os << suObject->name();
  }
  else if (!sourceName_.isEmpty()) {
    os << " from ";
    if (suProcess && suProcess != ::thisProcess)
      os << suProcess->name() << ":";
    os << sourceName_;
  }

  if (spObject) {
    os << " to ";
    if (spProcess && spProcess != ::thisProcess)
      os << spProcess->name() << ":";
    os << spObject->name();
  }
  else if (name() != className()) {
    os << " to ";
    if (spProcess && spProcess != ::thisProcess)
      os << spProcess->name() << ":";
    os << name();
  }

  os << " - " << state_ << "} ";
}

void Agent::ask(Istream& is) {
  Ostream& os = *is.tiedTo();
  String serviceName = className();
  //assumed that className() == serviceName + "_agent"
  serviceName[serviceName.length()-6] = 0;	
  String name;

  os << INDENT << *this << "\n";

#if 1	/*Cannot give a list of appropriate remote service providers*/
  Fifo q;
  ::namedObjs->selectElementsWithMember(serviceName, q); //local only
  os << INDENT << "Local service providers: " << q << "\n";
  os << INDENT << "Name of service provider? ";

#else
  os << INDENT << "Do you wish to see a list of local objects providing " 
     << serviceName << "?\n"; 
  os << INDENT << "In a distributed system, the query causes inter-process communication.\n";
  os << INDENT << "  (0/1)? ";
  boolean yes;
  is >> yes;
  if (yes) {
    Fifo q;
    ::namedObjs->selectElementsWithMember(serviceName, q);
    os << INDENT << "Select one of " << q << ": ";
  }
  else
    os << INDENT << "Name of service provider? ";
#endif

  is >> name;
  setSp(name); 		//if 'name' is local,
                        //checks that 'name' has a member 'serviceName'

  if (state_ == Agent::connectedToAnAgent && spProcess == ::thisProcess) {
    boolean useMessages = true;
    dout << INDENT << "Use messages (1) or direct function call (0) ? ";
    din >> useMessages;
    if (!useMessages)
      state_ = Agent::connectedToAnSP;
  }

  os << INDENT << "Now: " << *this << "\n";
}

void Agent::setSp(String spName) {
  Object* op;

  if (useCount_ > 1)
    OTSO_WARNING( "Modifying a " << name() << " shared by " << useCount_ << " Ptrs." );

  //I assume that className() == serviceName + "_agent"
  String serviceName = className();
  serviceName[serviceName.length()-6] = 0;

  NamedObj* n = ::namedObjs->pointer(spName);

  if (n == ::dummyNamedObj)
    OTSO_WARNING("Unknown object '" << spName << "': " << className() << " not changed.");
  else {
    void* ip = ::namedObjs->servicePointer(spName, serviceName, op);
    if (!ip) {
      if (n->process() == ::thisProcess) {
	//n is a local object, type checking implemented
	OTSO_WARNING( spName << " does not implement '" << serviceName << "'; " << className() << " not changed.");
	return;
      }
      else {
	//n is an agent, type checking not implemented
	OTSO_WARNING("Dynamic type checking of remote service providers not implemented; " << serviceName << "Ptr changed anyway.");
      }
    }
   
    setSPInterface(ip);			//virtual
    spObject = op;
    spProcess = op->process();
    spConId = 23456;			//?

    if (spObject && spObject->inQ())
      state_ = Agent::connectedToAnAgent;
    else {
      state_ = Agent::connectedToAnSP;
      if (!spObject)
	OTSO_ERROR("OTSO problem in Agent::setSp() : spObject==0, spInterface!=0");
    }
  }
}


void Agent::to(ODump& od) {
  String unknownObject = "unknownObject";

  if (spProcess) od << spProcess->name();	//?
  else {
    OTSO_ERROR( "Agent::to(): Cannot encode an incomplete " << className() << ": spProcess missing" );
    od << unknownObject;
  }

  if (spObject) od << spObject->name();	
  else {
    OTSO_ERROR( "Agent::to(): Cannot encode an incomplete " << className() << ": spObject missing" );
    od << unknownObject;
  }

  if (suProcess) od << suProcess->name();	//?
  else {
    OTSO_ERROR( "Agent::to(): Cannot encode an incomplete " << className() << ": suProcess missing" );
    od << unknownObject;
  }

  if (!sourceName().isEmpty())
    od << sourceName();
  else {
    OTSO_ERROR( "Agent::to(): Cannot encode an incomplete " << className() << ": su missing" );
    od << unknownObject;
  }
}

void Agent::from(IDump& id) {
                                            //destination SP
  String processName;
  id >> processName; BUGOUT("proc=" << processName);
  if (!id) return;
  Process* tmpProc = (Process*)(::namedObjs -> pointer(processName));
                                            //risky type cast!?
  if (tmpProc == ::dummyNamedObj) 
    OTSO_ERROR( "Agent::from() - Unknown destination process (" << processName );
#if 0
  if (tmpProc != ::thisProcess)
    OTSO_WARNING( ::thisProcess->name() << ":" << className() << " received a message to process " << processName );
#endif

  String objectName;	
  id >> objectName; 	BUGOUT("objName=" << objectName);
  Object* destObject = ::namedObjs -> pointer(objectName);
  if (destObject == ::dummyNamedObj) {
    OTSO_ERROR( "Agent::from() - Unknown dest object (" << objectName );
  } else {
    BUGOUT("destObject=" << *destObject);
  }

  setSp(objectName);

                                            //source SU
  id >> processName;	BUGOUT("procName = " << processName);
  tmpProc = (Process*)::namedObjs -> pointer(processName);
  suProcess = tmpProc;
  if (tmpProc == ::dummyNamedObj) 
    OTSO_WARNING( "Agent::from() - Unknown source process (" << processName );

#if 0
  if (tmpProc == ::thisProcess)
    OTSO_WARNING( ::thisProcess->name() << ":" << className() << " received a binary encoded message from itself !?" );
#endif

#if 0
  id >> objectName;  BUGOUT("objectName = " << objectName);
  Object* sourceObject = ::namedObjs -> pointer(objectName);
  if (sourceObject == ::dummyNamedObj)
    OTSO_WARNING("Unknown source object " << objectName );

  suObject = sourceObject;
#endif
  id >> sourceName_;  BUGOUT("sourceName = " << sourceName_);
  suObject = 0;

  suConId = 12345; //?
  BUGOUT("The whole Ptr = " << *this);
}

/**********************************************************************/

void MultiPtr::print(Ostream& os) {os << className() << " " << *agent();}
void MultiPtr::ask(Istream& is) {is >> *agent();}
void MultiPtr::to(ODump& od) {od << *agent();}
void MultiPtr::from(IDump& id) {id >> *agent();}

MultiPtr::MultiPtr() {} //explicit ctor to avoid duplication in executable (?)

/**********************************************************************/
