
//
// I have been thinking about naming conflicts in OTSO of OTSO classes
// with those provided by other libraries,  I think we should do something
// like the macro OTSOCLASS in the example below for all OTSO classes.
// Use of the macro would make life easier, if we decide to change the
// OTSO prefix at some future date (due to name conflicts, or compiler
// limitations(MSDOS?), etc).
//
// Initially, we could use:
//  #define OTSOCLASS(xxx) concat(/*OTSO_*/,xxx)
// So unmodified code would not be affected.  This would allow us
// to incrementally modify existing code.  When all possible
// places have been modified, the macro could be modified as below:
//
// prepro probably has to be modified to accept the syntax ?
//
// Any comments ?
//

#include "stream.h"

#define concat(a,b) a/*concat*/b
#define OTSOCLASS(xxx) concat(/*OTSO_*/,xxx)

class A { public: virtual void hi() { cout << "hi"; } };

class OTSOCLASS(B) : public A { public: virtual void hi(){cout << "bhi";} };

class OTSOCLASS(C) : public OTSOCLASS(B) {public:virtual void hi();};

void OTSOCLASS(C)::hi() {
  cout << "C hello";
}

main() {
  A x;
  OTSOCLASS(B) y;
  OTSOCLASS(C) z;

  x.hi();
  y.hi();
  z.hi();
}
