/**************************************************************
 * Send any comments or questions to: OTSO-Bug@tel.vtt.fi
 *
 * Name: /home/users/otso/official/otso/appli/simpleFileTransfer/SCCS/s.sftp.hx
 * Vers: 5.2    Time: 92/09/10, 15:51:20
 **************************************************************/

/***************************************************************
* Copyright (c) 1992      Technical Research Centre of Finland (VTT)
*
* Permission to use, copy, modify, and distribute this software and its
* documentation for any purpose and without fee is hereby granted, provided
* that this notice and the reference to this notice appearing in each software
* module be retained unaltered, and that the name of any contributors shall not
* be used in advertising or publicity pertaining to distribution of the software
* without specific written prior permission.  No contributor makes any
* representations about the suitability of this software for any purpose.
* It is provided "as is" without any express or limited warranty.
*
*			NO WARRANTY
*
* ALL CONTRIBUTORS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS.  IN NO
* EVENT SHALL ANY CONTRIBUTOR BE LIABLE FOR ANY SPECIAL, PUNITIVE, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA, OR PROFITS, WHETHER IN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH, THE USE OR PERFORMANCE
* OF THIS SOFTWARE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THIS
* SOFTWARE IS WITH YOU.  SHOULD THIS SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE
* COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION.
*
* As used above, "contributor" includes, but is not limited to :
*        The Technical Research Centre of Finland
***************************************************************/


implementation class sftp
  : public TranSU, public Runner
{

public:
  /* EFSA */
  enum efsaState {
    idle, connected, wconnected, open, wopen, goodbyeCruelWorld
  };
  efsaState	state;		// The current 'state' of the EFSA
  void		DEFAULT();	// OTSO generates code for this
  void		special_efsa();

  TranSPPtr	transportServiceProvider;
  redefined	TranSU_interface;

  virtual void	run();

  /* ctor/dtor */
  sftp (
    char *        hostname ,
    char *        localFilename ,
    char *        remoteFilename	= 0 ,
    int		  portnumber 		= 0 ,
    boolean       doGet 		= false ,
    boolean       doServe 		= false ,
    int           transferBlockSize	= 1024,
    boolean       chatty 		= false ,
    Group *       pgroup		= 0
  );

  ~sftp();
  void reset();


  /**** Encoding/Decoding of sftp PDUs ****/

  enum FileOperation {
    read	= 0 ,
    write	= 1
  };


 private:
  // DT identifier field
# define  LAST_DT_PDU	0x01	/* last DT_PDU  0000 0001 */
# define       DT_PDU	0x10	/* any  DT_PDU  0001 0000 */
# define  OPEN_REQ_PDU	0x20	/*              0010 0000 */
# define  OPEN_RSP_PDU	0x60	/*              0110 0000 */

  Frame	encodeOPEN_REQ_PDU (FileOperation op,	String name);
  Frame	encodeOPEN_RSP_PDU (boolean result,	String errorMsg);
  Frame	encodeDT_PDU       (Frame& data,	boolean isEOT=false);
  //void	decode (Frame& data);


  Frame handleOPEN_REQ_PDU(Frame& data);
    // handle open request pdu and generate response pdu

  boolean handleDT_PDU(Frame& data);
    // handle data transfer indications (write block to local file)
  
private:
  /* data members only */
  char*         s_remotehostname;
  char*         s_localfilename;
  char*         s_remotefilename;
  int		s_connecttoport;
  boolean       s_getop;
  boolean       s_isserver;
  boolean	s_isverbose;
  ifstream*     s_pifs;		// local input file
  ofstream*     s_pofs;		// local output file
  int		s_byteCount;		// number bytes transfered so far
  int		s_startTransferTime;	// secs when transfer started
  int		s_endTransferTime;	// secs when transfer started
  int		s_transferblocksize;	// size of blocks transferred DT
};

extern char* gettsapaddr (int port=0, char* host=0, char* pref=0);
