/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.licence;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.exception.ResourceNotFoundException;
import com.izforge.izpack.api.exception.UserInterruptException;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.installer.console.AbstractTextConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.installer.util.PanelHelper;
import com.izforge.izpack.util.Console;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public abstract class AbstractLicenceConsolePanel
extends AbstractTextConsolePanel {
    private static final String DEFAULT_SUFFIX = ".licence";
    private final Resources resources;
    private static final Logger logger = Logger.getLogger(AbstractLicenceConsolePanel.class.getName());

    public AbstractLicenceConsolePanel(PanelView<ConsolePanel> panel, Resources resources) {
        super(panel);
        this.resources = resources;
    }

    protected URL loadLicence() {
        URL url = null;
        Class<?> thisClazz = this.getClass();
        Class<IzPanel> izClass = PanelHelper.getIzPanel(thisClazz.getName());
        if (izClass != null) {
            String panelId;
            String resNamePrefix = izClass.getSimpleName();
            String resNameStr = resNamePrefix + DEFAULT_SUFFIX;
            Panel panel = this.getPanel();
            if (panel != null && (panelId = panel.getPanelId()) != null) {
                String panelSpecificResName = resNamePrefix + '.' + panelId;
                try {
                    url = this.resources.getURL(panelSpecificResName);
                }
                catch (ResourceNotFoundException e) {
                    try {
                        url = this.resources.getURL(resNameStr);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            }
            if (url == null) {
                panelId = panel != null ? panel.getPanelId() : null;
                logger.warning("Cannot open any of the possible license document resources (" + (panelId != null ? resNamePrefix + '.' + panelId + ", " : "") + resNamePrefix + DEFAULT_SUFFIX + ") for panel type '" + resNamePrefix + "");
            }
        } else {
            logger.warning("No IzPanel implementation found for " + thisClazz.getSimpleName());
        }
        return url;
    }

    protected String loadLicenceAsString() {
        return this.loadLicenceAsString("UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadLicenceAsString(String encoding) {
        URL url = null;
        String result = null;
        try {
            url = this.loadLicence();
            InputStream in = url.openStream();
            try {
                result = IOUtils.toString(in, Charsets.toCharset(encoding));
            }
            finally {
                IOUtils.closeQuietly(in);
            }
        }
        catch (IOException e) {
            logger.warning("Cannot convert license document from resource " + url.getFile() + " to text: " + e.getMessage());
        }
        return result;
    }

    @Override
    protected boolean promptEndPanel(InstallData installData, Console console) {
        boolean result;
        Messages messages = installData.getMessages();
        String prompt = messages.get("ConsoleInstaller.acceptRejectRedisplay", new Object[0]);
        console.println();
        int value = console.prompt(prompt, 1, 3, 2);
        switch (value) {
            case 1: {
                result = true;
                break;
            }
            case 2: {
                throw new UserInterruptException(messages.get("ConsoleInstaller.aborted.LicenseRejected", new Object[0]));
            }
            default: {
                result = this.run(installData, console);
            }
        }
        return result;
    }
}

