/*
 * Program:	Pine's composer and pico's function declarations
 *
 * Modifier:	Michael Seibel
 *		Networks and Distributed Computing
 *		Computing & Communications
 *		University of Washington
 *		Administration Building, AG-44
 *		Seattle, WA  98195
 *		Internet: mikes@cac.washington.edu
 *
 * Date:	14 Jan 90
 * Last Edited:	9 Jan 1991
 *
 * Copyright 1991 by the University of Washington
 *
 *  Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appears in all copies and that both the
 * above copyright notice and this permission notice appear in supporting
 * documentation, and that the name of the University of Washington not be
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  This software is made
 * available "as is", and
 * THE UNIVERSITY OF WASHINGTON DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT LIMITATION ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, AND IN
 * NO EVENT SHALL THE UNIVERSITY OF WASHINGTON BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, TORT
 * (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	EFUNC.H:	MicroEMACS function declarations and names

		This file list all the C code functions used by MicroEMACS
	and the names to use to bind keys to them. To add functions,
	declare it here in both the extern function list and the name
	binding table.

	Update History:

	Daniel Lawrence
*/

#ifndef	EFUNC_H
#define	EFUNC_H


/*	External function declarations		*/

extern  int     abort_composer();       /* Bag the whole burrito	*/
extern  int     suspend_composer();     /* Bag the whole burrito, for now */
extern  int     ctrlg();                /* Abort out of things          */
#ifdef	SPELLER
extern  int     spell();                /* Pico spelling checker        */
#endif
extern  int     wquit();                /* Pico Quit                    */
extern  int     quickexit();            /* Pico Quit from tool mode     */
extern  int     HeaderEditor();		/* edit mail header stuff       */
extern  int     spell();       /* hide mail header stuff       */
extern  int     fileread();             /* Get a file, read only        */
extern  int     filefind();		/* Get a file, read write       */
extern  int     filewrite();            /* Write a file                 */
extern  int     filesave();             /* Save current file            */
extern  int     filename();             /* Adjust file name             */
extern  int     getccol();              /* Get current column           */
extern  int     gotobol();              /* Move to start of line        */
extern  int     forwchar();             /* Move forward by characters   */
extern  int     gotoeol();              /* Move to end of line          */
extern  int     backchar();             /* Move backward by characters  */
extern  int     forwline();             /* Move forward by lines        */
extern  int     backline();             /* Move backward by lines       */
extern  int     forwpage();             /* Move forward by pages        */
extern  int     backpage();             /* Move backward by pages       */
extern  int     gotobob();              /* Move to start of buffer      */
extern  int     gotoeob();              /* Move to end of buffer        */
extern  int     setfillcol();           /* Set fill column.             */
extern  int     setmark();              /* Set mark                     */
extern  int     swapmark();             /* Swap "." and mark            */
extern  int     forwsearch();           /* Search forward               */
extern  int     showcpos();             /* Show the cursor position     */
extern  int     reposition();           /* Reposition window            */
extern  int     refresh();              /* Refresh the screen           */
extern  int     tab();                  /* Insert tab                   */
extern  int     newline();              /* Insert CR-LF                 */
extern  int     forwword();             /* Advance by words             */
extern  int     forwdel();              /* Forward delete               */
extern  int     backdel();              /* Backward delete              */
extern  int     killtext();             /* Kill a line                  */
extern  int     yank();                 /* Yank back from killbuffer.   */
extern	int	gotobop();		/* go to begining/paragraph	*/
extern	int	gotoeop();		/* go to end/paragraph		*/
extern	int	fillpara();		/* fill current paragraph	*/
extern	int	whelp();		/* get the help file here	*/
extern	int	insfile();		/* insert a file		*/

#if	JOB_CONTROL
extern	int	bktoshell();		/* suspend emacs to parent shell*/
extern	int	rtfrmshell();		/* return from a suspended state*/
extern	int	alt_editor();		/* edit body with another editor */
#endif	/* JOB_CONTROL */

/*	Name to function binding table

		This table gives the names of all the bindable functions
	end their C function address. These are used for the bind-to-key
	function.
*/

#ifdef	maindef

NBIND	names[] = {
	{"backward-character",		backchar},
	{"begining-of-file",		gotobob},
	{"begining-of-line",		gotobol},
	{"buffer-position",		showcpos},
	{"delete-next-character",	forwdel},
	{"delete-previous-character",	backdel},
	{"end-of-file",			gotoeob},
	{"end-of-line",			gotoeol},
#ifdef	SPELLER
	{"spell-check",			spell},
#endif
	{"exit-emacs",			wquit},
	{"exit-emacs-quick",		quickexit},
	{"fill-paragraph",		fillpara},
	{"forward-character",		forwchar},
	{"handle-tab",			tab},
	{"help",			whelp},
	{"insert-file",			insfile},
	{"newline",			newline},
	{"next-line",			forwline},
	{"next-page",			forwpage},
	{"next-paragraph",		gotoeop},
	{"next-word",			forwword},
	{"previous-line",		backline},
	{"previous-page",		backpage},
	{"previous-paragraph",		gotobop},
	{"read-file",			fileread},
	{"search-forward",		forwsearch},
	{"set-fill-column",		setfillcol},
#if	JOB_CONTROL
	{"suspend-emacs",		bktoshell},
#endif
	{"write-file",			filewrite},
	{"yank",			yank},

	{"",			NULL}
};

#endif
#endif	/* EFUNC_H */
