#!/bin/sh -
#
# Copyright (c) 1983 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms are permitted
# provided that the above copyright notice and this paragraph are
# duplicated in all such forms and that any documentation,
# advertising materials, and other materials related to such
# distribution and use acknowledge that the software was developed
# by the University of California, Berkeley.  The name of the
# University may not be used to endorse or promote products derived
# from this software without specific prior written permission.
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#
#	@(#)newvers.sh	5.4 (Berkeley) 12/7/88
#
if [ ! -r version ]; then echo 0 > version; fi
touch version

awk '	{	version = $1 + 1; }\
END	{	printf "#define BUILDNO	%d\n", version > "version.h";\
		printf "%d\n", version > "version"; }' < version

HOST=`if [ -f /bin/uname ]; then uname -n; else hostname; fi`
case $HOST in
*.*)	DOMAINHOST=$HOST
	;;
*)	if [ -f /etc/resolv.conf ]; then
		DOMAIN=`sed -e '/^[^d]/d' -e 's/^domain[ 	]*\([^ 	]*\)/\1/' \
			/etc/resolv.conf`
		DOMAINHOST=$HOST.$DOMAIN
	else
		DOMAINHOST=$HOST
	fi
	;;
esac

echo "#define BUILDER	\"${USER-${LOGNAME-root}}@$DOMAINHOST\"" >> version.h
echo "#define BUILDDATE	\"`date`\"" >> version.h

