#!/bin/sh
#
# vifinger --
#	edit finger data files
#
# Usage: vifinger [datafile]
#
# Edits a finger binary data file in ASCII format, then convertes the result
# back to binary.  Default file is /usr/spool/fingerdir/userdata.
# 
# Warning: Don't edit files while fingerd deamon is running !
#
# $Id: vifinger.sh,v 1.1 1992/07/01 21:06:19 stolcke Exp $
#

if [ $# -gt 1 ]; then
	echo "usage: $0 [datafile]"
	exit 2
fi

file=${1-/usr/spool/fingerdir/userdata}
afile=/tmp/fingerdata$$

trap '/bin/rm -f $file.new $afile.new; exit 0' 0 1 2 15

/usr/local/etc/packet2ascii < $file > $afile
${EDITOR-/usr/ucb/vi} $afile
/usr/local/etc/ascii2packet < $afile > $file.new
if cmp -s $file $file.new; then
	echo "$file unchanged"
else
	/usr/local/etc/packet2ascii < $file | /bin/diff - $afile
	echo -n "changes ok? "
	read answer
	case "$answer" in
	y*|Y*)
		/bin/mv $file.new $file
		/bin/rm $afile
		;;
	*)
		echo "changes left in $afile"
		;;
	esac
fi
