/*
 * text-finger.c --
 *	How to do textual GNU fingering.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: text-finger.c,v 1.6 1992/09/08 23:28:32 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>

#include "util.h"

/* Tell CONNECTION to send us the info on USER, and then print that
   info out. */
void
text_finger (user, connection)
     char *user;
     int connection;
{
  int fd;
  FILE *stream;
  char line[256];

  fd = dup (connection);

  if ((stream = fdopen (fd, "r+")) == (FILE *)NULL)
    return;

  fprintf (stream, "%s\r\n", user);
  fflush (stream);

  fseek (stream, 0l, 1);
	
  while (fgets (line, sizeof(line), stream))
    {
      int linelen = strlen (line);

      /* Since output is destined to local stdout, convert CR/NL sequences
	 back to UNIX \n. */
      if (linelen > 0 && line[linelen - 1] == '\n')
	if (linelen > 1 && line[linelen - 2] == '\r')
	  line[linelen - 2] = '\0';
	else
	  line[linelen - 1] = '\0';

      printf ("%s\n", line);
    }
  
  fflush (stdout);
  fclose (stream);
}

