/*
 * caltech_info.c --
 *	Here is the default method of printing out the verbose info on a given
 *	user.  It's reasonable, but you may want to add various things.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: caltech_info.c,v 1.5 1993/09/16 00:27:46 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <lastlog.h>
#include <sys/stat.h>
#include <pwd.h>

#include "util.h"
#include "packet.h"

/* Print out information about the user in ENTRY on STREAM.
   PACKETS contains some login state from the local machine. */
display_finger_info (entry, stream, packets)
     struct passwd *entry;
     FILE *stream;
     FINGER_PACKET **packets;
{
  register int i, packets_output = 0;
  struct stat finfo;
  char *mail_file = path_concat (MAILDIR, entry->pw_name);
  char *plan_file = path_concat (entry->pw_dir, ".plan");

  char *name, *building, *extension, *home_phone, *next_gecos_field ();

  name = entry->pw_gecos;
  building = next_gecos_field (name);
  extension = next_gecos_field (building);
  home_phone = next_gecos_field (extension);
  
  fprintf (stream, "\n%s (%s)\tHome: %s\n",
	   pw_real_name (entry), entry->pw_name, entry->pw_dir);
  fprintf (stream, "Building/Ext/Home:%s/%s/%s\n",
	   building, extension, home_phone);

  /* If the user is logged in, show the login packets. */
  if (packets)
    {
      for (i = 0; packets[i]; i++)
	{
	  if (strcmp (entry->pw_name, packets[i]->name) == 0)
	    {
	      packets_output++;
	      print_packet (packets[i], stream);
	    }
	}
    }

  /* If the user is not currently logged in, get the last known
     login time. */
  if (packets_output == 0)
    {
      struct lastlog logent;
      int file;

      if ((file = open (LASTLOG_FILE, O_RDONLY)) >= 0)
	{
	  if ((lseek (file, (long) (entry->pw_uid * sizeof (logent)), 0) != -1) &&
	      (read (file, &logent, sizeof (logent)) == sizeof (logent)))
	    {
	      fprintf (stream, "Last login on %s ",
		       logent.ll_line[0] ? logent.ll_line : "(no tty)");
	      if (logent.ll_host[0])
		fprintf (stream, "from %s, ", logent.ll_host);
	      fprintf (stream, "on %s", ctime (&(logent.ll_time)));
	    }
	  close (file);
	}
    }

  if (stat (mail_file, &finfo) < 0 || finfo.st_size == 0)
    fprintf (stream, "No mail.\n");
  else
    {
      if (finfo.st_atime < finfo.st_mtime)
	{
	  char *idle_time_string (), *temp_string;

	  fprintf (stream, "New mail since %s", ctime (&finfo.st_mtime));
	  temp_string =
	    idle_time_string ((time_t)time ((time_t *)0) - finfo.st_atime, 0);
	  fprintf (stream, "Has not read mail for %s.\n", temp_string);
	  free (temp_string);
	}
      else
	{
	  fprintf (stream, "No unread mail.\n");
	}
    }

  /* Maybe do the .plan file. */
  {
    FILE *istream = fopen (plan_file, "r");
    char buff[256];

    if (istream)
      {
/*	fprintf (stream, "Plan:\n"); */
	while (istream && fgets (buff, 256, istream))
	  fprintf (stream, "%s", buff);
	fclose (istream);
      }
    else
      fprintf (stream, "No plan.\n");
  }

  free (mail_file);
  free (plan_file);
  fflush (stream);
}

/* Return the next field in STRING.  STRING should be the beginning of the
   gecos field that you want to parse. */
char *
next_gecos_field (string)
     char *string;
{
  char *result = string;

  while (*result && *result != ',')
    result++;

  if (*result)
    {
      *result = '\0';
      result++;
    }
  return (result);
}

