/*
 * save_bitmap.c --
 *	How to save a BITMAP
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: save_bitmap.c,v 1.8 1993/12/16 10:39:56 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>

#include "general.h"
#include "bitmap.h"
#include "error.h"

int
save_bitmap (user, face)
     char *user;
     BITMAP *face;
{
  char *filename = mugshot_filename (user, NULL);
  int file;

  file = open (filename, O_WRONLY | O_CREAT | O_TRUNC, 0666);
  free (filename);

  if (!file)
    return (errno);

  write (file, &face->width, sizeof (face->width));
  write (file, &face->height, sizeof (face->height));
  write (file, &face->rowlen, sizeof (face->rowlen));

  write (file, face->bits, face->rowlen * face->height);

  close (file);
  return (0);
}
