/*
 * read_face.c --
 *	read the Facesaver format from uunet.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: read_face.c,v 1.6 1993/05/28 19:28:48 stolcke Exp $ ICSI (Berkeley)";
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>

#include "general.h"
#include "bitmap.h"

BITMAP *
read_face (user)
     char *user;
{
  FILE *file;
  BITMAP *face = (BITMAP *)NULL;
  char *filename = mugshot_filename (user, NULL);
  char line[128], *res;
  int size, width = 0, height = 0, depth = 0;

  file = fopen (filename, "r");
  free (filename);

  if (!file)
    return (BITMAP *)NULL;

  /* Get info about this file.  The file format is several lines, each one
     containing a label and a value, followed by the image data itself in
     an ASCII representation of hex. */
  while (1)
    {
      char *field_end;

      res = fgets (line, sizeof (line), file);

      if (res == (char *)NULL)
	break;

      /* Skip leading whitespace. */
      while (isspace (*res))
	res++;

      /* Ignore blank lines. */
      if (!*res)
	continue;

      /* If this is a field, then parse out it's value. */
      field_end = strrchr (res, ':');

      if (field_end)
	{
	  char *identifier = res;

	  *field_end = '\0';
	  res = field_end + 1;

	  if (strcmp (identifier, "PicData") == 0)
	    {
	      sscanf (res, "%d %d %d", &width, &height, &depth);
	    }
	}
      else
	break;
    }

  /* If we scanned in the width, height and depth, we can read the bits
     now. */
  if (depth)
    {
      int row, offset, tem;
      byte *image_row, *buffer;

      face = (BITMAP *)xmalloc (sizeof (BITMAP));

      face->width = width;
      face->height = height;

      if (depth == 8)
	face->rowlen = width;
      else
	face->rowlen = (width + 7) / 8;

      size = face->rowlen * height;

      buffer = (byte *)xmalloc (size);

      row = offset = 0;

      while (res = fgets (line, sizeof (line), file))
	{
	  char hex_rep[3];

	  hex_rep[2] = '\0';

	next_row:
	  /* Protect against malformed input files. */
	  if (row >= height)
	    break;

	  image_row = buffer + (row * face->rowlen);

	next_byte:

	  /* Skip leading whitespace. */
	  while (isspace (*res) || *res == ',')
	    res++;

	  if (!*res)
	    continue;

	  hex_rep[0] = *res++;
	  hex_rep[1] = *res++;
	  
	  sscanf (hex_rep, "%x", &tem);

	  image_row[offset++] = tem;

	  if (offset == face->rowlen)
	    {
	      offset = 0;
	      row++;
	      goto next_row;
	    }
	  goto next_byte;
	}

      if (depth == 8)
	{
	  byte *dither ();
#if 0
	  /* Byteswap the contents of this bitmap. */
	  for (i = 0; i < size; i +=2)
	    {
	      short tem = *(short *)&buffer[i];
	      BYTESWAP (tem);
	      *(short *)&buffer[i] = tem;
	    }
#endif	  
	  face->bits =
	    dither (buffer, face->width, face->height, face->rowlen);

	  face->rowlen = ROWBYTES (face->width);

	  reverse_image_bit_order (face);
	  free (buffer);
	}
      else
	face->bits = buffer;
    }

  fclose (file);
  
  return (face);
}

#ifdef TEST
/* Load a Facesaver file from disk and display it. */

main (argc, argv)
     int argc;
     char **argv;
{
  int arg_index = 1;

  while (arg_index != argc)
    {
      char *file = argv[arg_index++];
      BITMAP *face = read_face (file);

      if (face)
	{
	  x_show_face (file, face);
	  free (face->bits);
	  free (face);
	}
      else
	fprintf (stderr, "No face bits for `%s'.\n", file);
      
    }
}

site_save_face ()
{}

#endif
/*
 * Local variables:
 * compile-command: "gcc -DTEST -o showface read_face.c x_show_face.o bitmap.o util.o dither.o -lXaw -lXt -lXmu -lXext -lX11 -lm -I../include -g"
 * end.
 */
