/*
 * flock.c --
 *	BSD flock(2) emulation
 *
 * Copyright (C) 1992 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#if !defined(lint) && !defined(SABER)
static char *rcsid = "$Id: flock.c,v 1.1 1992/05/29 18:51:18 stolcke Exp $ ICSI (Berkeley)";
#endif

#include "../config.h"

#ifdef NEED_FLOCK

#include <fcntl.h>
#include <errno.h>

extern int errno;

#include <flock.h>

/*
 * Translate flock(2) functions into fcntl(2) calls.
 */
int
flock(fd, op)
	int fd;
	int op;
{
	struct flock lk;
	int ret;

	if (op & LOCK_SH)
		lk.l_type = F_RDLCK;
	else if (op & LOCK_EX)
		lk.l_type = F_WRLCK;
	else if (op & LOCK_UN)
		lk.l_type = F_UNLCK;

	lk.l_whence = 0;
	lk.l_start = 0;
	lk.l_len = 0;

	ret = fcntl(fd, (op & LOCK_NB) ? F_SETLK : F_SETLKW , &lk);

	if (ret < 0 && (errno == EACCES || errno == EAGAIN))
		errno = EWOULDBLOCK;

	return ret;
}
#endif /* NEED_FLOCK */
