/*
 * util.h --
 *	Simple utility functions that everyone uses.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: util.h,v 1.15 94/03/23 18:51:15 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_UTIL_H_)
#define _UTIL_H_

#include "../config.h"

#include <stdio.h>

/* Define macros which map BSD bzero/bcopy to their POSIX equivalent */
#ifdef HAVE_MEMORY
# define bzero(adr,len)		(void) memset(adr, 0, len)
# define bcopy(from, to, len)	(void) memcpy(to, from, len)
#endif

#ifdef USE_DBMALLOC
#include <sys/types.h>
#include <debug/malloc.h>

#define xmalloc(x)	malloc(x)
#define xrealloc(x,y)	realloc(x,y)

#include "error.h"

/* Convenience in checking for memory leaks */
#define CHECK_LEAK(where, CODE) { \
      unsigned long  histid1, histid2, orig_size, current_size; \
					\
      orig_size = malloc_inuse(&histid1); \
      CODE \
      current_size = malloc_inuse(&histid2); \
      debug (1, "%s: net allocation %d bytes\n", \
                where, current_size - orig_size);\
}

#else /* !USE_DBMALLOC */
#define CHECK_LEAK(where, CODE)	CODE

/* Like malloc () and realloc (), but abort if out of memory. */
void *xmalloc (), *xrealloc ();
#endif /* USE_DBMALLOC */

/* Return the length of the null terminated array of pointers. */
int array_len ();

/* Free the contents of the null terminated array, and then
   the array itself. */
void free_array ();

/* Fast toupper() using table lookup */
extern char toupper_table[];
#undef toupper
#define toupper(c)	(toupper_table[(unsigned)(c)])

#ifndef USE_DBMALLOC	/* malloc.h defines stricmp() */

/* avoid conflict with libc routines */
#define strnicmp	STRNICMP
#define stricmp		STRICMP

/* Compare at most COUNT characters from string1 to string2.  Case
   doesn't matter. */
int strnicmp ();

/* strcmp (), but caseless. */
int stricmp ();

#else /* USE_DBMALLOC */

/* the dbmalloc header file has a glitch: strnicmp is called strincmp */
#ifdef strincmp
#define strnicmp(x,y,n)	strincmp(x,y,n)
#endif

#endif /* !USE_DBMALLOC */

/* Determine if s2 occurs in s1.  If so, return a pointer to the
   match in s1.  The compare is case insensitive. */
char *strindex ();

/* Return a new string which is the concatenation of PATH and FILE. */
char *path_concat ();

/* Return a  string which is the English representation of the
   amount of idle time present in ITIME.  Note that ITIME is a time_t. */
char *idle_time_string ();

/* Return the real person name of ENTRY. */
char *pw_real_name ();

/* Open standard config file */
FILE *open_host_config ();

/* Close standard config file */
void close_host_config ();

/* Read keyed value from a config file */
char *get_config_entry ();

/* Match hostname against config file entries */
int match_host_config ();

#endif /* _UTIL_H_ */
