/*
 * tcp.h --
 *	What we need to finger with TCP protocol.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: tcp.h,v 1.6 1991/12/14 02:08:16 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_TCP_H_)
#define _TCP_H_

/* Don't forget to include sys/types.h before sys/socket.h. */

/* #include <sys/types.h> */
#include <sys/socket.h>

/* TCP service for fingering a client machine. */
#define CFINGER_SERVICE "cfinger"

/* TCP port number for CFINGER_SERVICE. */
#define CFINGER_PORT 2003

/* Number of micro-seconds before timing out on connect call.
   Zero value means no timeouts.  */
extern int connect_timeout;

/* Non-zero means only allow TIME_OUT micro-seconds for a connect () to
   succeed, instead of whatever the infernal network code allows. */
extern int allow_time_outs;

/* Number of micro-seconds before a connection read fails. */
extern int read_timeout;

/* Open a filedes to SERVICE at ADDRESS.  If SERVICE is the name of a
   service, then it must exist on the local machine.  SERVICE can also
   be the ASCII representation of a decimal number, in which case it is
   interpreted as the port number to connect to.  Returns a valid file
   descriptor if successful, or -1 if not. */
int tcp_to_service ();

/* Reliable read from a socket.
   Guaranteed to fill a buffer unless timed out. */
int sock_read();

/* check the socket s for local connected-ness
   return the peer address in name */
int local_socket();

#endif /* _TCP_H_ */
