/*
 * getservhost.h --
 *	Description of getservhost.c
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: getservhost.h,v 1.3 1992/01/08 01:35:06 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_GETSERVHOST_H_)
#define _GETSERVHOST_H_

/* Flags to getservhost() */
#define GETSERV_LOCAL		0	/* find the local server (default) */
#define GETSERV_GLOBAL		0x01	/* find the global server */
#define GETSERV_NOERROR		0x02	/* suppress error messages */

/* Return a new string which is the name of the local GNU Finger server
   host.  If this cannot be determined, return a NULL pointer instead.
   Single argument ERROR_STREAM is a stream to print errors to; a NULL
   value for this argument means print no errors. */
char *getservhost ();

#endif /* _GETSERVHOST_H_ */
