/*
 * general.h --
 *	Generally useful macros and defines.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: general.h,v 1.6 1993/01/01 20:25:58 stolcke Exp $ ICSI (Berkeley)
 */

/* Copyright (C) 1988,1990 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   GNU Finger is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation; either version 1, or (at your
   option) any later version.

   GNU Finger is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Finger; see the file COPYING.  If not, write to the
   Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */

#if !defined (_GENERAL_H_)
#define _GENERAL_H_

#include <string.h>	/* for strcpy() */
#include "util.h"	/* for xmalloc(), xrealloc() */

/* An 8-bit byte. */
#ifndef byte
#define byte unsigned char
#endif

/* So I can say (Function *)foo; */
typedef int Function ();

#ifndef savestring
#define savestring(s) strcpy ((char *)xmalloc (1 + strlen (s)), (s))
#endif

#define LOCALHOST	"localhost"

#endif /* _GENERAL_H_ */
