/*
 * error.h --
 *	Defines used when calling the error handlers.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: error.h,v 1.7 1993/02/06 01:08:54 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_ERROR_H_)
#define _ERROR_H_

#include <stdio.h>
#include <setjmp.h>

/* error log types */
#define LOG_NONE	((FILE *)0)
#define LOG_SYS		((FILE *)-1)

/* Classes of error. */
#define FATAL 0			/* Stops the program. */
#define ERROR 1			/* Stops the function.  */
#define ALERT 2			/* Demands immediate attention. */
#define WARNING 3		/* Makes noise, and informs. */
#define DEBUG 4			/* Makes noise only if debuggging. */

extern int errno;		/* sometime missing from <errno.h> */

extern char *progname;
extern jmp_buf top_level;

void default_error_handling ();
void handle_error (), file_error ();
void warning (), debug ();

#endif /* _ERROR_H_ */
