/*
 * client.h --
 *	Data structures used by the useful GNU finger.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: client.h,v 1.8 1994/03/18 20:01:32 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_CLIENT_H_)
#define _CLIENT_H_

/* What a client looks like. */
typedef struct {
  char hostname[64];
  struct in_addr address;
  int status;			/* Status flags */
  int users;			/* Number of active users. */
  time_t idle_time;		/* If up, length of time idle.
				   If down, time first found down. */
  int times_polled;		/* Number of times successfully polled. */
} CLIENT;

/* flags in status field */
#define CLIENT_UP	0x01	/* Is client even up ? */
#define CLIENT_LASTLOG	0x02	/* Have we got the lastlog data yet */
#define CLIENT_GATEWAY	0x04	/* Gateway to another finger domain ? */
#define CLIENT_LOCAL	0x08	/* The local host */

#endif /* _CLIENT_H_ */
