/*
 * bitmap.h --
 *	What a finger/face bitmap looks like.  Everywhere.  Even if you
 *	don't have bitmaps.
 *
 * Copyright (C) 1988,1990 Free Software Foundation, Inc.
 * Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
 *
 * This file is part of GNU Finger.
 * 
 * GNU Finger is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 1, or (at your
 * option) any later version.
 *
 * GNU Finger is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Finger; see the file COPYING.  If not, write to the
 * Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: bitmap.h,v 1.5 1993/05/28 20:03:46 stolcke Exp $ ICSI (Berkeley)
 */

#if !defined (_BITMAP_H_)
#define _BITMAP_H_

/* Boundary to which each row of the bitmap is expected to be padded. */
#define BOUNDARY 16
#define ROWBYTES(w) ((((w) + (BOUNDARY - 1)) / BOUNDARY) * (BOUNDARY / 8))

#define BYTESWAP(x) { char *t = (char *)&(x), u; u = *t; *t = t[1]; t[1] = u; }

#ifndef NULL
#define NULL 0x0
#endif

#ifndef byte
#define byte unsigned char
#endif

/* The structure that defines what a bitmap looks like. */
typedef struct {
  int width;			/* Width in bits. */
  int height;			/* Height in bits. */
  int rowlen;			/* Number of bytes in each row. */
  byte *bits;			/* Location of the bits. */
} BITMAP;

#if defined (MugShotPath)
#define MUGSHOT_PATH MugShotPath
#else
#define MUGSHOT_PATH "/usr/local/lib/mugshots:/usr/local/mugshots"
#endif

#ifndef FACEFILE
#define FACEFILE	".face"
#endif

/* Useful functions supplied by this file. */

/* Write the bits of USER's face on STREAM, in the standard face format.
   If we can.  We first send the width, the height, and the length of
   each row in bytes.  These are printed in ASCII representation.  Then
   we send height lines of width bytes.  We don't care about byte swapping,
   because any finger that calls us knows the standard format of bitmaps. */
void send_face ();

/* Modify the bitmap pointed to by FACE so that each row is
   padded to WORD_SIZE.  To pad to a single byte, WORD_SIZE should
   be 1, 16-bit boundary is 2, etc. */
void pad_face ();

/* Return a malloc'ed string which is the name of a mugshot file for USER.
   Search for a .face file in the user's home directory, and then
   through the list of possible pathnames taken from the environment
   variable `MUGSHOT_PATH', or defaulting to the CPP variable MUGSHOT_PATH.
   If the file exists, return that name, otherwise return the first possible
   filename for USER. */
char *mugshot_filename ();/* mugshot_filename (char *user, struct passwd *pw) */

/* Some machines expect the bit ordering to be in one order, some in 
   another order.  This function changes the LSBit to MSBit in each
   byte of BITMAP. */
void reverse_image_bit_order ();

/* Some machines have 0 as white and 1 as black.  Swap the bits in BITMAP. */
void invert_image_bits ();

/* Given a string containing units of information separated by colons,
   return the next one pointed to by INDEX, or NULL if there are no more.
   Advance INDEX to the character after the colon. */
char *extract_colon_unit ();

#endif  /* _BITMAP_H_ */
