'\"
'\" Copyright (C) 1992 International Computer Science Institute, Berkeley, USA.
'\"
'\" This file is part of GNU Finger.
'\" 
'\" GNU Finger is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License as published
'\" by the Free Software Foundation; either version 1, or (at your
'\" option) any later version.
'\"
'\" GNU Finger is distributed in the hope that it will be useful, but
'\" WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'\" General Public License for more details.
'\"
'\" You should have received a copy of the GNU General Public License
'\" along with GNU Finger; see the file COPYING.  If not, write to the
'\" Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'\"
.TH HOSTCONFIG 5 "$Date: 1994/11/16 20:45:01 $"
.SH NAME
hostconfig \- GNU finger host configuration file
.SH DESCRIPTION
The file
.B hostconfig
in the GNU finger directory (fingerdir) contains information about
various aspects of the setup of a collection of finger daemons.
All information is organized as pairs of attribute keywords and associated
values, one per line:
.nf

	\fIkeyword\fP	\fIvalue\fP

.fi
.I keyword
is the first word of non-whitespace characters on the line, whereas
.I value
is taken to be everything following, stripped of any leading and trailing
whitespace.
Keyword matching is case-insensitive.
A pound sign (#) as the first non-whitespace character on the line
marks the text following as a comment that is ignored.
Empty lines are likewise ignored.
.PP
In cases where only one instance of an attribute value is meaningful
only the first one is significant.
.SH ATTRIBUTES
The following are all the
.IR keyword s
currently used by the various programs
in the GNU finger system, with their associated semantics.
.TP 12
.B server
.I value
is the name of a host where finger requests that access global
information (such as last logins) should be forwarded to.
This host should run a 
.BR gfingerd (8)
daemon set up to globally gather finger information.
This attribute has to be specified for proper operation of all finger
programs.
.TP
.B lserver
.I value
is the name of host running a local finger daemon, polling a subset of hosts
and possibly being polled by others as a gateway.
This attribute is only required on the host in question and if different from
.BR server .
.TP
.B smtphost
The
.I value
is a hostname or IP address pointing to a mail server machine running an
SMTP server such as
.BR sendmail (8).
It is used by
.BR in.fingerd (8)
to check mail aliases.
(If a user's username resolves to itself as per SMTP then it is assumed
that the user's local mailbox can be checked for incoming messages.)
An empty
.I value
field defaults to the local host.
A missing
.B smtphost
suppresses mail alias lookup altogether.
.TP
.B domainname
Overrides the local domain name that would be determined otherwise.
In the absence of this attribute, finger tries to consult
.BR resolv.conf (5),
.BR gethostname (2)
(if the hostname appears to be fully qualified)
or
.BR getdomainname (2),
in that order.
The domain is used to normalize and/or strip local hostnames.
.TP
.B localnet
This attribute can be used repeatedly to specify prefixes of IP numbers
(e.g., 
.BR 123.45.67. )
that identify `local' hosts as far a finger is concerned.
Local hosts have certain priviledges like special finger requests
and may be replied to using different formats
(see
.BR gfinger (1)).
An empty value lets all hosts appear to be local.
If the attribute is omitted, no machines are considered local
(this may not be very useful as some functionality will be completely
unavailable in this case).
.TP
.B denyhost
This attribute directs
.B in.fingerd
to deny connections from certain hosts.
Hosts can be specified either as hostnames, full IP numbers, domain suffixes
(with a leading dot), or IP number prefixes (with a trailing dot).
Note that hostnames or IP number are not interchangeable; rather, IP
numbers are used only if the peer's address cannot be resolved to a hostname.
.TP
.B denyuser
This attribute directs
.B in.fingerd
to deny connections from certain users.
The user is given by its login name on the remote system.
This feature is not reliable since it relies on support for the RFC 931
identification protocol; it may be useful to prevent access by certain
information gathering services like
.BR netfind (1).
.TP
.B authenticate
An attribute that specifies hosts or subdomains (in the manner of
.BR denyhost )
for which
.B in.fingerd
should attempt to query the remote user name through the
.B auth/ident
protocol implemented by
.BR identd (8).
In particular, specifying the attribute without a value enables
remote user identification for all connections.
.TP
.B longoutput
An attribute that specifies hosts or subdomains (in the manner of
.BR denyhost )
for which
.B in.fingerd
should generate ``long'' output by default when indivdual users
are fingered.
Long output typically includes information
about mail status, .project and .plan files, etc.
.TP
.B logconnect
This attribute directs
.B in.fingerd
to log connections from certain hosts, along with the input lines
given to the finger daemon.
Hosts are specified as for
.BR denyhost .
.TP
.B allowindirect
This attribute tells
.B in.fingerd
that a certain host or domain is allowed to perform `indirect' fingering
through the local host, using multiple `@' characters in the finger target.
This allows the local host to be a stepping stone for connections from
other hosts to third party hosts, and maybe used to circumvent access
restrictions.
The rules for hostname specification are as for
.BR denyhost ;
specifying "localnet" tells finger to allow indirect fingering for all
`local' connections (as per
.BR localnet ).
.TP
.B acctfile
The value is the name of a file from which finger tries to glean
the name of the last command run by a user.  By default this is the
standard system accounting file, unless the functionality has been
disabled entirely at compile time.
An empty value disables accounting file lookups.
.TP
.B printwidths
This sets a global default for the
.B \-widths
option to
.BR gfinger (1).
The value of this attribute must conform to the same syntax as the option
argument.
.TP
.BR defaultlocal ,\  defaultremote
Specifies a default target (special finger or user name) to use if none
was passed by the finger client, for local and remote connections,
respectively.
This defaults to
.B .all
in both cases, but some sites may prefer to set
.B defaultlocal
to
.BR .local ,
or
.B defaultremote
to
.BR .site ,
etc.
.TP
.BR defaultself
The default target for connections from "localhost" (the loopback interface),
which are typically those from the
.BR gfinger (1)
front-end.
This overrides both 
.B defaultlocal
and
.BR defaultremote ,
and can be used to have "gfinger" return a format different from
"gfinger @host".
.TP
.B client
.I value
specifies a client host for polling by
.BR gfingerd (8).
The specification may take on several forms.
.RS
.TP 15
.I hostname
The named host is polled for its local logins.
.TP
.I IP-address
The host with the given IP address is polled for its local logins.
.TP
.B :local
The finger daemon polls the local host internally (without establishing
a connection with
.BR in.cfingerd ).
.TP
.BI :local \ host
The finger daemon polls the specified host's login records internally
through the file system.  (This is currently only supported in
HP-UX clustered environments.)
.I host
can be either a hostname of IP address.
.TP
.BI :gateway \ host
The
.I host
is assumed to be running another finger daemon and polled for
all login records in that daemon's database.
This allows a hierarchical (or mutual) multi-level polling scheme to
be set up (cf. the
.B lserver
attibute above).
.I host
can be either a hostname of IP address.
.RE
.PP
Attributes that perform hostname or IP number matching also allow
entries to be `negated.'  An entry starting with a `!' is matched
as usual (without the leading character) and produces a negative result
if successful, thus preventing following entries from matching.
For example
.sp 1
.nf
logconnect	!.Berkeley.EDU
logconnect
.fi
.sp 1
would log all connections from outside the
.B Berkeley.EDU
domain.
.SH FILES
.B /usr/local/etc/fingerdir/hostconfig
.PD
.SH "SEE ALSO"
gfinger(1), gfingerd(8), cfingerd(8), identd(8).
