'\"
'\" Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
'\"
'\" This file is part of GNU Finger.
'\" 
'\" GNU Finger is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License as published
'\" by the Free Software Foundation; either version 1, or (at your
'\" option) any later version.
'\"
'\" GNU Finger is distributed in the hope that it will be useful, but
'\" WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'\" General Public License for more details.
'\"
'\" You should have received a copy of the GNU General Public License
'\" along with GNU Finger; see the file COPYING.  If not, write to the
'\" Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'\"
.TH GFINGERD 8 "$Date: 1993/01/03 02:03:37 $"
.SH NAME
gfingerd \- GNU finger server daemon
.SH SYNOPSIS
.B /usr/local/etc/gfingerd
.RI [ options ]
.SH DESCRIPTION
.B Gfingerd
is a daemon that runs permanently on a finger server host periodically
polling its client hosts to keep the global finger databases up to date.
It cooperates with two other daemons that are invoked on demand:
.B in.cfingerd
to reply to polls on the client hosts,
and
.B in.fingerd
to read the databases and prepare formatted output on request by a user.
.PP
.B Gfingerd
looks in the
.BR hostconfig (5)
file for the
.B server
and
.B lserver
hostnames to verify that is is running on an appropriate host.
It also scans
.B client
specifications in that file to set up its list of finger clients to poll.
.PP
In its first polling cycle, it will try to obtain a full dump
of each clients lastlog database to initialize the global user database.
.SH OPTIONS
.TP 15
.PD 0
.BI \-connect-timeout \ timeout
Sets the time after which a polling connection attempt fails to
.I timeout
microseconds.
The default is .75 seconds.
A
.I timeout
of 0 specifies that the default of the underlying system be used.
Hosts that cannot establish connection in the specified amount of time
will be considered down.
.TP
.BI \-poll-timeout \ timeout
Sets the time allowed for a read on the polling connection to return data,
in microseconds.
The default is 1.5 seconds, but may have to be increased considerably depending
on the expected amount of data and the load on the client system.
A
.I timeout 
of 0 specifies waiting forever until data arrives.
.TP
.BI \-poll-interval \ interval
Specifies the number of seconds the finger daemon will sleep between polling
cycles.
The default is 2 minutes.
Note the maximum age of the polled data is given by this interval plus
the time that the polling cycle itself takes.
.TP
.B \-poll-debug
Track the polling cycle with debugging output.
For each client polled, its name and number of packets returned is
logged.
.TP
.B  \-debug
Full debugging output.
In addition to the information printed by
.BR  \-poll-debug ,
this also prints the finger packets returned by each poll.
Also, the daemon will not detach itself into the background,
and connection timeouts are disabled.
Error messages and debugging output is directed to stderr rather than
the system log.
.PD
.SH SIGNALS
.PD 0
.TP 20
SIGHUP
Reread clients list and tty locations database (for local polling).
.TP
SIGUSR1
Enable poll debugging.
.TP
SIGUSR2
Disable poll debugging.
.TP
SIGINT, SIGTERM
Graceful termination.
.PD
.SH FILES
.PD 0
.TP 20
.B /usr/local/etc/fingerdir/hostconfig
Names of server and client hosts.
.TP
.B /usr/local/etc/fingerdir/hostdata
Host database of current logins.
.TP
.B /usr/local/etc/fingerdir/userdata
User database of most recent logins.
.TP
.B /usr/local/etc/fingerdir/clientstatus
Client info database.
.PD
.SH "SEE ALSO"
gfinger(1), cfingerd(8), hostconfig(5), Emacs Info on
.IR finger .
.SH BUGS
Databases not optimized for very large number of hosts/users.
.br
Outdated finger packets from hosts that are down are not discarded
if local and remote hostnames do not match.
.br
Gateway polling is naive, will not prevent packets from circulating back
to the originating server.
