'\"
'\" Copyright (C) 1991 International Computer Science Institute, Berkeley, USA.
'\"
'\" This file is part of GNU Finger.
'\" 
'\" GNU Finger is free software; you can redistribute it and/or modify
'\" it under the terms of the GNU General Public License as published
'\" by the Free Software Foundation; either version 1, or (at your
'\" option) any later version.
'\"
'\" GNU Finger is distributed in the hope that it will be useful, but
'\" WITHOUT ANY WARRANTY; without even the implied warranty of
'\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'\" General Public License for more details.
'\"
'\" You should have received a copy of the GNU General Public License
'\" along with GNU Finger; see the file COPYING.  If not, write to the
'\" Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
'\"
.TH CFINGERD 8 "$Date: 1993/01/03 02:03:37 $"
.SH NAME
cfingerd, in.cfingerd \- GNU finger client daemon
.SH SYNOPSIS
.B /usr/local/etc/in.cfingerd
.SH DESCRIPTION
.B Cfingerd
is the daemon invoked on a finger client host by the
.BR gfingerd (8)
daemon on the server host to poll local login
information.
It is invoked upon connection request on TCP port
.B cfinger 
(2003 by default) by
.BR inetd (8)
and reads one line of data from the server.
It then writes zero or more finger packets back to the server.
.PP
The input line is usually empty to request default polling mode.
However, one or more of the following pseudo-options can be given in the
input to modify the default action.
.TP 15
.PD 0
.B \-debug
Write packets in ASCII format for debugging purposes.  The default is to
write in the binary format
.B gfingerd
expects.
.TP
.B \-lastlog
Extract and write finger packets corresponding to the lastlog database 
maintained by the system.
The default action is to write finger packets corresponding the currently
logged in users.
This option is used once by
.B gfingerd
after startup to initialize the user database.
.TP
.B \-all-hosts
If
.B cfingerd
is running on the same machine as
.BR gfingerd ,
this causes the entire host database to be written, containing information
about all hosts served by that
.BR  gfingerd .
If combined with
.BR \-lastlog ,
the entire user database is written.
The default is to write information about just the local host.
This option is used by
.B gfingerd
to poll another finger domain through a gateway host.
.TP
.B \-all-users
Requests all logins for all local users.
By default only the least idle login for each user is returned.
This option is currently not used by
.BR gfingerd ,
but may be useful in combination with
.BR \-debug .
.PD
.PP
.B Cfingerd
will fail silently if any errors prevent the requested action.
Also, only connections from `local' hosts are allowed, as specified by
.B hostconfig (5).
.SH FILES
.PD 0
.TP 20
.B /usr/local/etc/fingerdir/hostconfig
Name of finger server host.
.TP
.B /usr/local/etc/fingerdir/ttylocs
Terminal locations database.
.TP
.B /usr/local/etc/fingerdir/hostdata
Host database of current logins.
.TP
.B /usr/local/etc/fingerdir/userdata
User database of most recent logins.
.TP
.B /etc/utmp
Current login database maintained by UNIX.
.TP
.B /usr/adm/lastlog
Lastlog database maintained by UNIX.
.PD
.SH "SEE ALSO"
utmp(5), gfinger(1), gfingerd(8), hostconfig(5), ttylocs(5), Emacs Info on
.IR finger .
