/*****************************************************************************
  FILE           : $Source: /usr/local/bv/SNNS/SNNSv4.1/rpc/sources/RCS/ui_rpcfile.c,v $
  SHORTNAME      : ui_rpcfile
  SNNS VERSION   : 4.1

  PURPOSE        : 
  NOTES          :

  AUTHOR         : Sven Doering
  DATE           : 

  CHANGED BY     : 
  IDENTIFICATION : $State: Exp $ $Locker:  $
  RCS VERSION    : $Revision: 1.5 $
  LAST CHANGE    : $Date: 1995/11/16 07:27:52 $

             (c) 1994 by Sven Doering and the SNNS-Group

******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#if ! defined ultrix
#include <sys/dirent.h>
#endif
#include <dirent.h>
#include <sys/stat.h>

#if defined RPCSNNS && defined RPCXGUI

#include "glob_typ.h"
#include <rpc/rpc.h>
#include "kr_ui_rpc.h"
#include "kr_ui.h"

extern CLIENT *clienthandle; /*is in #include "ui_rpc.h" but require the X-Includes*/

#endif

DIR *rpc_opendir(char *dirname)
{
#if defined RPCSNNS && defined RPCXGUI
    DIR **res;
    
    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(NULL); 
	}
	res = rpc_opendir_40(&dirname , clienthandle);
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(NULL);
	}else{
	    return(*res);
	}
    }
#endif

    return(opendir(dirname) );
}

struct dirent *rpc_readdir(DIR *dirp)
{
#if defined RPCSNNS && defined RPCXGUI
    struct rpc_dirent *res;
    static struct dirent dire;

    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(NULL); 
	}
	if (dirp != NULL){
	    res = rpc_readdir_40(&dirp , clienthandle);
        }else{
	    return(NULL);
	}
	
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(NULL);
	}else{
	    if(res->last_entry == TRUE){
		return(NULL);
	    }
#if ! defined __PARAGON__ && ! defined ultrix
	    dire.d_off = res->d_off;
#endif
	    dire.d_reclen = res->d_reclen;       
#ifndef __linux__
	    dire.d_fileno = res->d_fileno;       
	    dire.d_namlen = res->d_namlen;       
#endif
	    if (strcmp(res->d_name, null_ptr)==0) {
		dire.d_name[0] = '\0';
	    }else{
		strncpy(dire.d_name,res->d_name,255);
	    }
	    return(&dire);
	}
    }
#endif

    return(readdir(dirp) );
}

int rpc_closedir(DIR *dirp)
{
#if defined RPCSNNS && defined RPCXGUI
    int *res;
    
    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(0); 
	}
	if (dirp != NULL){
	    res = rpc_closedir_40(&dirp , clienthandle);
        }else{
	    return(0);
	}
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(0);
	}else{
	    return(*res);
	}
    }
#endif

    return(closedir(dirp) );
}

char *rpc_getcwd(char *buf, int size)
{
#if defined RPCSNNS && defined RPCXGUI
    char **res;
    par_getcwd par;
    
    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(NULL); 
	}
	if(buf == NULL){
	    par.buf= null_ptr;
	}else{
	    par.buf = buf;
	}
	par.size = size;
	res = rpc_getcwd_40(&par , clienthandle);
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(NULL);
	}else{
	    if (strcmp(*res, null_ptr)==0) {
		return(NULL);
	    }else{
		if(buf == NULL)
		    buf = (char *)malloc(size+1);
		strncpy(buf,*res,size);
		return(*res);
	    }
	}
    }
#endif

    return(getcwd(buf,size) );
}

int rpc_access(char *path, int mode)
{
#if defined RPCSNNS && defined RPCXGUI
    int *res;
    par_access par;
    
    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(-1); 
	}
	if(path == NULL){
	    par.path = null_ptr;
	}else{
	    par.path = path;
	}
	par.mode = mode;
	res = rpc_access_40(&par , clienthandle);
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(-1);
	}else{
	    return(*res);
	}
    }
#endif

    return(access(path,mode) );
}




int  rpc_stat(char *path, struct stat *buf)
{
#if defined RPCSNNS && defined RPCXGUI
    res_stat *res;
    
    if(rpckernel){
	if ( clienthandle == (CLIENT *)NULL){ 
	    krui_execHandler(RPC_NO_SERVER); 
	    return(-1); 
	}
	if(path == NULL){
	    res = rpc_stat_40(&null_ptr, clienthandle);
	}else{
	    res = rpc_stat_40(&path , clienthandle);
	}
	if (res == NULL){
	    krui_execHandler(RPC_CALL_ERROR);
	    return(-1);
	}else{
	    buf->st_dev = res->st_dev;
	    buf->st_ino = res->st_ino;
	    buf->st_mode = res->st_mode;
	    buf->st_nlink = res->st_nlink;
	    buf->st_uid = res->st_uid;
	    buf->st_gid = res->st_gid;
	    buf->st_rdev = res->st_rdev;
	    buf->st_size = res->st_size;
	    buf->st_atime = res->st_atime;
	    buf->st_mtime = res->st_mtime;
	    buf->st_ctime = res->st_ctime;
	    buf->st_blksize = res->st_blksize;
	    buf->st_blocks = res->st_blocks;
	    
	    return(res->return_value);
	}
    }
#endif

    return(stat(path,buf) );
}




